/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import androidx.recyclerview.widget.RecyclerView;
import carbon.Carbon;
import carbon.R;
import carbon.recycler.ListAdapter;
import carbon.widget.CheckBox;
import carbon.widget.FrameLayout;
import carbon.widget.LinearLayout;
import carbon.widget.RecyclerView;
import carbon.widget.TextView;
import java.text.Format;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableView
extends RecyclerView {
    Map<Class, CellRenderer> cellRenderers = new HashMap<Class, CellRenderer>();

    public TableView(Context context) {
        super(context);
        this.initTableView(context);
    }

    public TableView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTableView(context);
    }

    public TableView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTableView(context);
    }

    private void initTableView(Context context) {
        this.setLayoutManager((RecyclerView.LayoutManager)new RecyclerView.LinearLayoutManager(context));
        this.putCellRenderer(String.class, new StringRenderer());
        this.putCellRenderer(Integer.class, new IntegerRenderer());
        this.putCellRenderer(Float.class, new FloatRenderer());
        this.putCellRenderer(Boolean.class, new BooleanRenderer());
    }

    private CellRenderer getCellRenderer(Class c) {
        return this.cellRenderers.get(c);
    }

    public void putCellRenderer(Class c, CellRenderer cellRenderer) {
        this.cellRenderers.put(c, cellRenderer);
    }

    public static class BooleanRenderer
    implements CellRenderer<Boolean, FrameLayout> {
        @Override
        public FrameLayout getView(Context context) {
            FrameLayout layout2 = new FrameLayout(context);
            CheckBox checkBox = new CheckBox(context);
            checkBox.setPadding(0, 0, 0, 0);
            checkBox.setEnabled(false);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
            params.gravity = 17;
            layout2.addView((View)checkBox, (ViewGroup.LayoutParams)params);
            return layout2;
        }

        @Override
        public void bindView(FrameLayout view, Boolean value, Format format) {
            ((CheckBox)view.getChildAt(0)).setChecked(value);
        }
    }

    public static class FloatRenderer
    implements CellRenderer<Float, TextView> {
        @Override
        public TextView getView(Context context) {
            TextView textView = new TextView(context);
            textView.setPadding((int)context.getResources().getDimension(R.dimen.carbon_padding), 0, (int)context.getResources().getDimension(R.dimen.carbon_padding), 0);
            textView.setGravity(8388629);
            textView.setTextColor(Carbon.getThemeColor(context, 16842806));
            textView.setTextSize(2, 13.0f);
            textView.setMaxLines(1);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            return textView;
        }

        @Override
        public void bindView(TextView view, Float value, Format format) {
            if (format != null) {
                view.setText(format.format(value));
            } else {
                view.setText(String.valueOf(value));
            }
        }
    }

    public static class IntegerRenderer
    implements CellRenderer<Integer, TextView> {
        @Override
        public TextView getView(Context context) {
            TextView textView = new TextView(context);
            textView.setPadding((int)context.getResources().getDimension(R.dimen.carbon_padding), 0, (int)context.getResources().getDimension(R.dimen.carbon_padding), 0);
            textView.setGravity(8388629);
            textView.setTextColor(Carbon.getThemeColor(context, 16842806));
            textView.setTextSize(2, 13.0f);
            textView.setMaxLines(1);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            return textView;
        }

        @Override
        public void bindView(TextView view, Integer value, Format format) {
            if (format != null) {
                view.setText(format.format(value));
            } else {
                view.setText(value);
            }
        }
    }

    public static class StringRenderer
    implements CellRenderer<String, TextView> {
        @Override
        public TextView getView(Context context) {
            TextView textView = new TextView(context);
            textView.setPadding((int)context.getResources().getDimension(R.dimen.carbon_padding), 0, (int)context.getResources().getDimension(R.dimen.carbon_padding), 0);
            textView.setGravity(16);
            textView.setTextColor(Carbon.getThemeColor(context, 16842806));
            textView.setTextSize(2, 13.0f);
            textView.setMaxLines(1);
            textView.setEllipsize(TextUtils.TruncateAt.END);
            return textView;
        }

        @Override
        public void bindView(TextView view, String value, Format format) {
            view.setText(value);
        }
    }

    public static interface CellRenderer<T, V extends View> {
        public V getView(Context var1);

        public void bindView(V var1, T var2, Format var3);
    }

    public static abstract class Adapter
    extends ListAdapter<ViewHolder, List<?>> {
        private TableView tableView;

        public Adapter(TableView tableView) {
            this.tableView = tableView;
        }

        public abstract String getColumnName(int var1);

        public abstract Class getColumnClass(int var1);

        public abstract int getColumnCount();

        public int getColumnWeight(int column) {
            return 1;
        }

        public Format getColumnFormat(int column) {
            return null;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            LinearLayout linearLayout = (LinearLayout)View.inflate((Context)parent.getContext(), (int)R.layout.carbon_tablelayout_row, null);
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)new RecyclerView.LayoutParams(-1, -2));
            linearLayout.setMinimumHeight((int)parent.getContext().getResources().getDimension(R.dimen.carbon_tableRowHeight));
            float weightSum = 0.0f;
            for (int i = 0; i < this.getColumnCount(); ++i) {
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1, this.getColumnWeight(i));
                linearLayout.addView((View)this.tableView.getCellRenderer(this.getColumnClass(i)).getView(parent.getContext()), (ViewGroup.LayoutParams)params);
                weightSum += (float)this.getColumnWeight(i);
            }
            linearLayout.setWeightSum(weightSum);
            return new ViewHolder((View)linearLayout);
        }

        @Override
        public void onBindViewHolder(ViewHolder holder, int position) {
            for (int i = 0; i < holder.row.getChildCount(); ++i) {
                View cell = holder.row.getChildAt(i);
                CellRenderer cellRenderer = this.tableView.getCellRenderer(this.getColumnClass(i));
                cellRenderer.bindView(cell, ((List)this.getItem(position)).get(i), this.getColumnFormat(i));
            }
        }

        static class ViewHolder
        extends RecyclerView.ViewHolder {
            LinearLayout row;

            public ViewHolder(View itemView) {
                super(itemView);
                this.row = (LinearLayout)itemView;
            }
        }
    }
}

