/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.AttrRes;
import carbon.Carbon;
import carbon.R;
import carbon.view.TextAppearanceView;

public class TextMarker
extends View {
    TextPaint textPaint;
    Rect rect = new Rect();
    Rect rect2 = new Rect();
    CharSequence text = "H";
    private int id;
    private int baseline = 0;
    private StaticLayout layout;

    public TextMarker(Context context) {
        super(context);
    }

    public TextMarker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public TextMarker(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, @AttrRes int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextMarker, defStyleAttr, 0);
            for (int i = 0; i < a.getIndexCount(); ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.TextMarker_carbon_text) {
                    this.setText(a.getText(attr2).toString());
                    continue;
                }
                if (attr2 != R.styleable.TextMarker_carbon_textView) continue;
                this.id = a.getResourceId(attr2, 0);
            }
            a.recycle();
        }
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence text) {
        this.text = text;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.id != 0) {
            TextAppearanceView textView = (TextAppearanceView)((ViewGroup)this.getParent()).findViewById(this.id);
            if (this.text == null) {
                this.text = textView.getText();
            }
            this.textPaint = textView.getPaint();
            if (this.layout == null) {
                this.layout = new StaticLayout(this.text, this.textPaint, this.getMeasuredWidth(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            }
            String firstLine = this.text.subSequence(0, this.layout.getLineEnd(0)).toString();
            this.textPaint.getTextBounds(firstLine, 0, firstLine.length(), this.rect);
            this.baseline = Math.abs(this.rect.top);
            this.rect.top = -this.layout.getLineAscent(0) + this.rect.top;
            String lastLine = this.text.subSequence(this.layout.getLineStart(this.layout.getLineCount() - 1), this.layout.getLineEnd(this.layout.getLineCount() - 1)).toString();
            this.textPaint.getTextBounds(lastLine, 0, lastLine.length(), this.rect2);
            this.rect.bottom = this.layout.getHeight() - this.layout.getLineDescent(this.layout.getLineCount() - 1) + this.rect2.bottom;
            this.setMeasuredDimension(this.getMeasuredWidth(), this.rect.height() + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    public int getBaseline() {
        return this.baseline + this.getPaddingTop();
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            Paint paint = new Paint();
            paint.setColor(Carbon.getThemeColor(this.getContext(), R.attr.colorError));
            canvas.drawLine(0.0f, (float)this.getBaseline(), (float)this.getWidth(), (float)this.getBaseline(), paint);
        }
    }
}

