/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.DynamicLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import carbon.Carbon;
import carbon.R;
import carbon.animation.AnimatedColorStateList;
import carbon.animation.AnimatedView;
import carbon.animation.StateAnimator;
import carbon.drawable.ripple.RippleDrawable;
import carbon.drawable.ripple.RippleView;
import carbon.internal.RevealAnimator;
import carbon.view.AllCapsTransformationMethod;
import carbon.view.AutoSizeTextView;
import carbon.view.MarginView;
import carbon.view.MaxSizeView;
import carbon.view.RevealView;
import carbon.view.ShadowView;
import carbon.view.ShapeModelView;
import carbon.view.StateAnimatorView;
import carbon.view.StrokeView;
import carbon.view.TextAppearanceView;
import carbon.view.TintedView;
import carbon.view.TouchMarginView;
import carbon.view.ValidStateView;
import carbon.view.VisibleView;
import carbon.widget.AutoSizeTextMode;
import carbon.widget.Label;
import carbon.widget.OnTransformationChangedListener;
import carbon.widget.PopupWindow;
import com.google.android.material.shape.CornerTreatment;
import com.google.android.material.shape.CutCornerTreatment;
import com.google.android.material.shape.MaterialShapeDrawable;
import com.google.android.material.shape.RoundedCornerTreatment;
import com.google.android.material.shape.ShapeAppearanceModel;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@SuppressLint(value={"AppCompatCustomView"})
public class TextView
extends android.widget.TextView
implements ShadowView,
RippleView,
TouchMarginView,
StateAnimatorView,
AnimatedView,
ShapeModelView,
TintedView,
StrokeView,
MaxSizeView,
ValidStateView,
AutoSizeTextView,
RevealView,
VisibleView,
MarginView,
TextAppearanceView {
    TextPaint paint = new TextPaint(3);
    int cursorColor;
    private boolean valid = true;
    private static int[] rippleIds = new int[]{R.styleable.TextView_carbon_rippleColor, R.styleable.TextView_carbon_rippleStyle, R.styleable.TextView_carbon_rippleHotspot, R.styleable.TextView_carbon_rippleRadius};
    private static int[] animationIds = new int[]{R.styleable.TextView_carbon_inAnimation, R.styleable.TextView_carbon_outAnimation};
    private static int[] touchMarginIds = new int[]{R.styleable.TextView_carbon_touchMargin, R.styleable.TextView_carbon_touchMarginLeft, R.styleable.TextView_carbon_touchMarginTop, R.styleable.TextView_carbon_touchMarginRight, R.styleable.TextView_carbon_touchMarginBottom};
    private static int[] tintIds = new int[]{R.styleable.TextView_carbon_tint, R.styleable.TextView_carbon_tintMode, R.styleable.TextView_carbon_backgroundTint, R.styleable.TextView_carbon_backgroundTintMode, R.styleable.TextView_carbon_animateColorChanges};
    private static int[] strokeIds = new int[]{R.styleable.TextView_carbon_stroke, R.styleable.TextView_carbon_strokeWidth};
    private static int[] cornerCutRadiusIds = new int[]{R.styleable.TextView_carbon_cornerRadiusTopStart, R.styleable.TextView_carbon_cornerRadiusTopEnd, R.styleable.TextView_carbon_cornerRadiusBottomStart, R.styleable.TextView_carbon_cornerRadiusBottomEnd, R.styleable.TextView_carbon_cornerRadius, R.styleable.TextView_carbon_cornerCutTopStart, R.styleable.TextView_carbon_cornerCutTopEnd, R.styleable.TextView_carbon_cornerCutBottomStart, R.styleable.TextView_carbon_cornerCutBottomEnd, R.styleable.TextView_carbon_cornerCut};
    private static int[] maxSizeIds = new int[]{R.styleable.TextView_carbon_maxWidth, R.styleable.TextView_carbon_maxHeight};
    private static int[] elevationIds = new int[]{R.styleable.TextView_carbon_elevation, R.styleable.TextView_carbon_elevationShadowColor, R.styleable.TextView_carbon_elevationAmbientShadowColor, R.styleable.TextView_carbon_elevationSpotShadowColor};
    private static int[] autoSizeTextIds = new int[]{R.styleable.TextView_carbon_autoSizeText, R.styleable.TextView_carbon_autoSizeMinTextSize, R.styleable.TextView_carbon_autoSizeMaxTextSize, R.styleable.TextView_carbon_autoSizeStepGranularity};
    RevealAnimator revealAnimator;
    private RectF boundsRect = new RectF();
    private Path cornersMask = new Path();
    private RippleDrawable rippleDrawable;
    private float elevation = 0.0f;
    private float translationZ = 0.0f;
    private ShapeAppearanceModel shapeModel = new ShapeAppearanceModel();
    private MaterialShapeDrawable shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
    private ColorStateList ambientShadowColor;
    private ColorStateList spotShadowColor;
    private Rect touchMargin = new Rect();
    final RectF tmpHitRect = new RectF();
    private StateAnimator stateAnimator = new StateAnimator(this);
    private static final int[] INVALID_STATE_SET = new int[]{R.attr.carbon_state_invalid};
    private Animator inAnim = null;
    private Animator outAnim = null;
    private Animator animator;
    ColorStateList tint;
    PorterDuff.Mode tintMode;
    ColorStateList backgroundTint;
    PorterDuff.Mode backgroundTintMode;
    boolean animateColorChanges;
    ValueAnimator.AnimatorUpdateListener tintAnimatorListener = animation -> {
        this.updateTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };
    ValueAnimator.AnimatorUpdateListener backgroundTintAnimatorListener = animation -> {
        this.updateBackgroundTint();
        ViewCompat.postInvalidateOnAnimation((View)this);
    };
    ValueAnimator.AnimatorUpdateListener textColorAnimatorListener = animation -> this.setHintTextColor(this.getHintTextColors());
    private ColorStateList stroke;
    private float strokeWidth;
    private Paint strokePaint;
    int maxWidth = Integer.MAX_VALUE;
    int maxHeight = Integer.MAX_VALUE;
    private AutoSizeTextMode autoSizeText = AutoSizeTextMode.None;
    private float minTextSize;
    private float maxTextSize;
    private float autoSizeStepGranularity;
    private float[] autoSizeStepPresets;
    private RectF textRect = new RectF();
    private RectF availableSpaceRect = new RectF();
    private float spacingMult = 1.0f;
    private float spacingAdd = 0.0f;
    private int maxLines = -1;
    List<OnTransformationChangedListener> transformationChangedListeners = new ArrayList<OnTransformationChangedListener>();

    public TextView(Context context) {
        super(context);
        this.initTextView(null, 16842884, R.style.carbon_TextView);
    }

    public TextView(Context context, String text) {
        super(context);
        this.initTextView(null, 16842884, R.style.carbon_TextView);
        this.setText(text);
    }

    public TextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initTextView(attrs, 16842884, R.style.carbon_TextView);
    }

    public TextView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTextView(attrs, defStyleAttr, R.style.carbon_TextView);
    }

    @TargetApi(value=21)
    public TextView(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initTextView(attrs, defStyleAttr, defStyleRes);
    }

    private void initTextView(AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TextView, defStyleAttr, defStyleRes);
        int ap = a.getResourceId(R.styleable.TextView_android_textAppearance, -1);
        if (ap != -1) {
            Carbon.setTextAppearance(this, ap, a.hasValue(R.styleable.TextView_android_textColor), false);
        }
        int textStyle = a.getInt(R.styleable.TextView_android_textStyle, 0);
        int fontWeight = a.getInt(R.styleable.TextView_carbon_fontWeight, 400);
        for (int i = 0; i < a.getIndexCount(); ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.TextView_carbon_font) {
                Carbon.handleFontAttribute(this, a, textStyle, fontWeight, attr2);
                continue;
            }
            if (attr2 == R.styleable.TextView_android_textAllCaps) {
                this.setAllCaps(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.TextView_android_singleLine) {
                this.setSingleLine(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 != R.styleable.TextView_android_maxLines) continue;
            this.setMaxLines(a.getInt(attr2, Integer.MAX_VALUE));
        }
        Carbon.initDefaultBackground((View)this, a, R.styleable.TextView_android_background);
        Carbon.initDefaultTextColor(this, a, R.styleable.TextView_android_textColor);
        Carbon.initRippleDrawable(this, a, rippleIds);
        Carbon.initElevation(this, a, elevationIds);
        Carbon.initTint(this, a, tintIds);
        Carbon.initAnimations(this, a, animationIds);
        Carbon.initTouchMargin(this, a, touchMarginIds);
        Carbon.initMaxSize(this, a, maxSizeIds);
        Carbon.initHtmlText(this, a, R.styleable.TextView_carbon_htmlText);
        Carbon.initStroke(this, a, strokeIds);
        Carbon.initCornerCutRadius(this, a, cornerCutRadiusIds);
        Carbon.initAutoSizeText(this, a, autoSizeTextIds);
        this.setTooltipText(a.getText(R.styleable.TextView_carbon_tooltipText));
        a.recycle();
        try {
            Field mHighlightPaintField = android.widget.TextView.class.getDeclaredField("mHighlightPaint");
            mHighlightPaintField.setAccessible(true);
            mHighlightPaintField.set(this, new Paint(){

                public void setColor(int color2) {
                    if (TextView.this.getSelectionStart() == TextView.this.getSelectionEnd()) {
                        super.setColor(TextView.this.cursorColor);
                    } else {
                        super.setColor(color2);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.refreshDrawableState();
    }

    @Override
    public void setAllCaps(boolean allCaps) {
        if (allCaps) {
            this.setTransformationMethod(new AllCapsTransformationMethod(this.getContext()));
        } else {
            this.setTransformationMethod(null);
        }
    }

    public void setLineHeight(int lineHeight) {
        int fontHeight = this.getPaint().getFontMetricsInt(null);
        if (lineHeight != fontHeight) {
            this.setLineSpacing(lineHeight - fontHeight, 1.0f);
        }
    }

    @Override
    public void setTextColor(@NotNull ColorStateList colors) {
        ColorStateList textColors = this.animateColorChanges && !(colors instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(colors, this.textColorAnimatorListener) : colors;
        super.setTextColor(textColors);
        if (textColors instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)textColors).setState(this.getDrawableState());
        }
    }

    public void setTextAppearance(@NonNull Context context, @StyleRes int resId) {
        super.setTextAppearance(context, resId);
        Carbon.setTextAppearance(this, resId, false, false);
    }

    public void setTextAppearance(@StyleRes int resId) {
        super.setTextAppearance(this.getContext(), resId);
        Carbon.setTextAppearance(this, resId, false, false);
    }

    @Override
    public void setValid(boolean valid) {
        if (this.valid == valid) {
            return;
        }
        this.valid = valid;
        this.refreshDrawableState();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public boolean isEmpty() {
        return this.getText().length() == 0;
    }

    public Point getLocationOnScreen() {
        int[] outLocation = new int[2];
        super.getLocationOnScreen(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    public Point getLocationInWindow() {
        int[] outLocation = new int[2];
        super.getLocationInWindow(outLocation);
        return new Point(outLocation[0], outLocation[1]);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(View hotspot, float startRadius, float finishRadius) {
        int[] location = new int[2];
        hotspot.getLocationOnScreen(location);
        int[] myLocation = new int[2];
        this.getLocationOnScreen(myLocation);
        return this.createCircularReveal(location[0] - myLocation[0] + hotspot.getWidth() / 2, location[1] - myLocation[1] + hotspot.getHeight() / 2, startRadius, finishRadius);
    }

    @Override
    @NotNull
    public Animator createCircularReveal(int x, int y, float startRadius, float finishRadius) {
        startRadius = Carbon.getRevealRadius((View)this, x, y, startRadius);
        finishRadius = Carbon.getRevealRadius((View)this, x, y, finishRadius);
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            Animator circularReveal = ViewAnimationUtils.createCircularReveal((View)this, (int)x, (int)y, (float)startRadius, (float)finishRadius);
            circularReveal.setDuration(Carbon.getDefaultRevealDuration());
            return circularReveal;
        }
        this.revealAnimator = new RevealAnimator(x, y, startRadius, finishRadius);
        this.revealAnimator.setDuration(Carbon.getDefaultRevealDuration());
        this.revealAnimator.addUpdateListener(animation -> {
            RevealAnimator reveal = (RevealAnimator)animation;
            reveal.radius = ((Float)reveal.getAnimatedValue()).floatValue();
            reveal.mask.reset();
            reveal.mask.addCircle(reveal.x, reveal.y, Math.max(((Float)reveal.getAnimatedValue()).floatValue(), 1.0f), Path.Direction.CW);
            this.postInvalidate();
        });
        this.revealAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationCancel(Animator animation) {
                TextView.this.revealAnimator = null;
            }

            public void onAnimationEnd(Animator animation) {
                TextView.this.revealAnimator = null;
            }
        });
        return this.revealAnimator;
    }

    @Override
    @NotNull
    public ShapeAppearanceModel getShapeModel() {
        return this.shapeModel;
    }

    @Override
    public void setCornerRadius(float cornerRadius) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new RoundedCornerTreatment(cornerRadius)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setCornerCut(float cornerCut) {
        this.shapeModel = ShapeAppearanceModel.builder().setAllCorners((CornerTreatment)new CutCornerTreatment(cornerCut)).build();
        this.setShapeModel(this.shapeModel);
    }

    @Override
    public void setShapeModel(@NotNull ShapeAppearanceModel model) {
        this.shapeModel = model;
        this.shadowDrawable = new MaterialShapeDrawable(this.shapeModel);
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            this.updateCorners();
        }
        if (!Carbon.IS_LOLLIPOP_OR_HIGHER) {
            this.postInvalidate();
        }
    }

    public void setOverScrollMode(int overScrollMode) {
        super.setOverScrollMode(overScrollMode);
        this.fixSpannableEllipsis();
    }

    private void fixSpannableEllipsis() {
        if (this.maxLines > 1 && this.maxLines < Integer.MAX_VALUE && this.getEllipsize() != null && this.getText() instanceof Spannable) {
            try {
                Field staticField = DynamicLayout.class.getDeclaredField("sStaticLayout");
                staticField.setAccessible(true);
                StaticLayout layout2 = (StaticLayout)staticField.get(DynamicLayout.class);
                if (layout2 != null) {
                    Field field = StaticLayout.class.getDeclaredField("mMaximumVisibleLineCount");
                    field.setAccessible(true);
                    field.setInt(layout2, this.maxLines);
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.onMeasure2(widthMeasureSpec, heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) == Integer.MIN_VALUE && this.getMeasuredWidth() == View.MeasureSpec.getSize((int)widthMeasureSpec) && this.getEllipsize() == null) {
            StaticLayout layout2 = new StaticLayout(this.getText(), this.getPaint(), this.getMeasuredWidth(), Layout.Alignment.ALIGN_NORMAL, this.spacingMult, this.spacingAdd, true);
            int width = 0;
            for (int i = 0; i < layout2.getLineCount(); ++i) {
                width = (int)Math.max((float)width, layout2.getLineMax(i));
            }
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)(width + this.getPaddingLeft() + this.getPaddingRight()), (int)0x40000000), heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!changed) {
            return;
        }
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        this.updateCorners();
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void updateCorners() {
        if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (!Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
                this.setClipToOutline(true);
            }
            this.setOutlineProvider(new ViewOutlineProvider(){

                public void getOutline(View view, Outline outline) {
                    if (Carbon.isShapeRect(TextView.this.shapeModel, TextView.this.boundsRect)) {
                        outline.setRect(0, 0, TextView.this.getWidth(), TextView.this.getHeight());
                    } else {
                        TextView.this.shadowDrawable.setBounds(0, 0, TextView.this.getWidth(), TextView.this.getHeight());
                        TextView.this.shadowDrawable.setShadowCompatibilityMode(1);
                        TextView.this.shadowDrawable.getOutline(outline);
                    }
                }
            });
        }
        this.boundsRect.set(this.shadowDrawable.getBounds());
        this.shadowDrawable.getPathForSize(this.getWidth(), this.getHeight(), this.cornersMask);
    }

    public void drawInternal(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.stroke != null) {
            this.drawStroke(canvas);
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Over) {
            this.rippleDrawable.draw(canvas);
        }
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(@NonNull Canvas canvas) {
        boolean c;
        boolean r = this.revealAnimator != null;
        boolean bl = c = !Carbon.isShapeRect(this.shapeModel, this.boundsRect);
        if (Carbon.IS_PIE_OR_HIGHER) {
            if (this.spotShadowColor != null) {
                super.setOutlineSpotShadowColor(this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()));
            }
            if (this.ambientShadowColor != null) {
                super.setOutlineAmbientShadowColor(this.ambientShadowColor.getColorForState(this.getDrawableState(), this.ambientShadowColor.getDefaultColor()));
            }
        }
        if (this.isInEditMode()) {
            if ((r || c) && this.getWidth() > 0 && this.getHeight() > 0) {
                Bitmap layer = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas layerCanvas = new Canvas(layer);
                this.drawInternal(layerCanvas);
                Bitmap mask = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas maskCanvas = new Canvas(mask);
                Paint maskPaint = new Paint(-1);
                maskCanvas.drawPath(this.cornersMask, maskPaint);
                for (int x = 0; x < this.getWidth(); ++x) {
                    for (int y = 0; y < this.getHeight(); ++y) {
                        int maskPixel = mask.getPixel(x, y);
                        layer.setPixel(x, y, Color.alpha((int)maskPixel) > 0 ? layer.getPixel(x, y) : 0);
                    }
                }
                canvas.drawBitmap(layer, 0.0f, 0.0f, (Paint)this.paint);
            } else {
                this.drawInternal(canvas);
            }
        } else if (this.getWidth() > 0 && this.getHeight() > 0 && ((r || c) && !Carbon.IS_LOLLIPOP_OR_HIGHER || !this.shapeModel.isRoundRect(this.boundsRect))) {
            int saveCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), null, 31);
            if (r) {
                int saveCount2 = canvas.save();
                canvas.clipRect(this.revealAnimator.x - this.revealAnimator.radius, this.revealAnimator.y - this.revealAnimator.radius, this.revealAnimator.x + this.revealAnimator.radius, this.revealAnimator.y + this.revealAnimator.radius);
                this.drawInternal(canvas);
                canvas.restoreToCount(saveCount2);
            } else {
                this.drawInternal(canvas);
            }
            this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
            if (c) {
                this.cornersMask.setFillType(Path.FillType.INVERSE_WINDING);
                canvas.drawPath(this.cornersMask, (Paint)this.paint);
            }
            if (r) {
                canvas.drawPath(this.revealAnimator.mask, (Paint)this.paint);
            }
            this.paint.setXfermode(null);
            canvas.restoreToCount(saveCount);
            this.paint.setXfermode(null);
        } else {
            this.drawInternal(canvas);
        }
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (this.shadowDrawable.isPointInTransparentRegion((int)event.getX(), (int)event.getY())) {
            return false;
        }
        if (this.rippleDrawable != null && event.getAction() == 0) {
            this.rippleDrawable.setHotspot(event.getX(), event.getY());
        }
        return super.dispatchTouchEvent(event);
    }

    @Override
    public RippleDrawable getRippleDrawable() {
        return this.rippleDrawable;
    }

    @Override
    public void setRippleDrawable(RippleDrawable newRipple) {
        if (this.rippleDrawable != null) {
            this.rippleDrawable.setCallback(null);
            if (this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable(this.rippleDrawable.getBackground());
            }
        }
        if (newRipple != null) {
            newRipple.setCallback((Drawable.Callback)this);
            newRipple.setBounds(0, 0, this.getWidth(), this.getHeight());
            newRipple.setState(this.getDrawableState());
            ((Drawable)newRipple).setVisible(this.getVisibility() == 0, false);
            if (newRipple.getStyle() == RippleDrawable.Style.Background) {
                super.setBackgroundDrawable((Drawable)newRipple);
            }
        }
        this.rippleDrawable = newRipple;
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || this.rippleDrawable == who;
    }

    public void invalidateDrawable(@NonNull Drawable drawable2) {
        super.invalidateDrawable(drawable2);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(@NonNull Rect dirty) {
        super.invalidate(dirty);
        this.invalidateParentIfNeeded();
    }

    public void invalidate(int l, int t, int r, int b) {
        super.invalidate(l, t, r, b);
        this.invalidateParentIfNeeded();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateParentIfNeeded();
    }

    private void invalidateParentIfNeeded() {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).invalidate();
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).invalidate();
        }
    }

    public void postInvalidateDelayed(long delayMilliseconds) {
        super.postInvalidateDelayed(delayMilliseconds);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    public void postInvalidateDelayed(long delayMilliseconds, int left, int top, int right, int bottom) {
        super.postInvalidateDelayed(delayMilliseconds, left, top, right, bottom);
        this.postInvalidateParentIfNeededDelayed(delayMilliseconds);
    }

    private void postInvalidateParentIfNeededDelayed(long delayMilliseconds) {
        if (this.getParent() == null || !(this.getParent() instanceof View)) {
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Borderless) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
        if (this.elevation > 0.0f || !Carbon.isShapeRect(this.shapeModel, this.boundsRect)) {
            ((View)this.getParent()).postInvalidateDelayed(delayMilliseconds);
        }
    }

    public void setBackground(Drawable background) {
        this.setBackgroundDrawable(background);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background instanceof RippleDrawable) {
            this.setRippleDrawable((RippleDrawable)background);
            return;
        }
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() == RippleDrawable.Style.Background) {
            this.rippleDrawable.setCallback(null);
            this.rippleDrawable = null;
        }
        super.setBackgroundDrawable(background);
        this.applyBackgroundTint();
    }

    public void setCompoundDrawables(@Nullable Drawable left, @Nullable Drawable top, @Nullable Drawable right, @Nullable Drawable bottom) {
        super.setCompoundDrawables(left != null ? DrawableCompat.wrap((Drawable)left) : null, top != null ? DrawableCompat.wrap((Drawable)top) : null, right != null ? DrawableCompat.wrap((Drawable)right) : null, bottom != null ? DrawableCompat.wrap((Drawable)bottom) : null);
        this.applyTint();
    }

    @Override
    public float getElevation() {
        return this.elevation;
    }

    @Override
    public void setElevation(float elevation) {
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setElevation(elevation);
            super.setTranslationZ(this.translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setElevation(elevation);
                super.setTranslationZ(this.translationZ);
            } else {
                super.setElevation(0.0f);
                super.setTranslationZ(0.0f);
            }
        } else if (elevation != this.elevation && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.elevation = elevation;
    }

    @Override
    public float getTranslationZ() {
        return this.translationZ;
    }

    @Override
    public void setTranslationZ(float translationZ) {
        if (translationZ == this.translationZ) {
            return;
        }
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setTranslationZ(translationZ);
        } else if (Carbon.IS_LOLLIPOP_OR_HIGHER) {
            if (this.ambientShadowColor == null || this.spotShadowColor == null) {
                super.setTranslationZ(translationZ);
            } else {
                super.setTranslationZ(0.0f);
            }
        } else if (translationZ != this.translationZ && this.getParent() != null) {
            ((View)this.getParent()).postInvalidate();
        }
        this.translationZ = translationZ;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public boolean hasShadow() {
        return this.getElevation() + this.getTranslationZ() >= 0.01f && this.getWidth() > 0 && this.getHeight() > 0;
    }

    @Override
    public void drawShadow(@NotNull Canvas canvas) {
        int saveCount;
        boolean r;
        float alpha = this.getAlpha() * Carbon.getBackgroundTintAlpha((View)this) / 255.0f;
        if (alpha == 0.0f || !this.hasShadow()) {
            return;
        }
        float z = this.getElevation() + this.getTranslationZ();
        boolean maskShadow = this.getBackground() != null && alpha != 1.0f;
        boolean bl = r = this.revealAnimator != null && this.revealAnimator.isRunning();
        if (alpha != 1.0f) {
            this.paint.setAlpha((int)(255.0f * alpha));
            saveCount = canvas.saveLayer(-z, -z, (float)canvas.getWidth() + z, (float)canvas.getHeight() + z, (Paint)this.paint, 31);
        } else {
            saveCount = canvas.save();
        }
        if (r) {
            canvas.clipRect((float)this.getLeft() + this.revealAnimator.x - this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y - this.revealAnimator.radius, (float)this.getLeft() + this.revealAnimator.x + this.revealAnimator.radius, (float)this.getTop() + this.revealAnimator.y + this.revealAnimator.radius);
        }
        this.shadowDrawable.setFillColor(this.spotShadowColor);
        this.shadowDrawable.setShadowColor(this.spotShadowColor != null ? this.spotShadowColor.getColorForState(this.getDrawableState(), this.spotShadowColor.getDefaultColor()) : -16777216);
        this.shadowDrawable.setShadowCompatibilityMode(2);
        this.shadowDrawable.setAlpha(68);
        this.shadowDrawable.setElevation(z);
        this.shadowDrawable.setShadowVerticalOffset(0);
        this.shadowDrawable.setBounds(this.getLeft(), (int)((float)this.getTop() + z / 4.0f), this.getRight(), (int)((float)this.getBottom() + z / 4.0f));
        this.shadowDrawable.draw(canvas);
        canvas.translate((float)this.getLeft(), (float)this.getTop());
        this.paint.setXfermode((Xfermode)Carbon.CLEAR_MODE);
        if (maskShadow) {
            this.cornersMask.setFillType(Path.FillType.WINDING);
            canvas.drawPath(this.cornersMask, (Paint)this.paint);
        }
        if (r) {
            canvas.drawPath(this.revealAnimator.mask, (Paint)this.paint);
        }
        canvas.restoreToCount(saveCount);
        this.paint.setXfermode(null);
        this.paint.setAlpha(255);
    }

    @Override
    public void setElevationShadowColor(ColorStateList shadowColor) {
        this.ambientShadowColor = this.spotShadowColor = shadowColor;
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public void setElevationShadowColor(int color2) {
        this.ambientShadowColor = this.spotShadowColor = ColorStateList.valueOf((int)color2);
        this.setElevation(this.elevation);
        this.setTranslationZ(this.translationZ);
    }

    @Override
    public ColorStateList getElevationShadowColor() {
        return this.ambientShadowColor;
    }

    @Override
    public void setOutlineAmbientShadowColor(int color2) {
        this.setOutlineAmbientShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineAmbientShadowColor(ColorStateList color2) {
        this.ambientShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineAmbientShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineAmbientShadowColor() {
        return this.ambientShadowColor.getDefaultColor();
    }

    @Override
    public void setOutlineSpotShadowColor(int color2) {
        this.setOutlineSpotShadowColor(ColorStateList.valueOf((int)color2));
    }

    @Override
    public void setOutlineSpotShadowColor(ColorStateList color2) {
        this.spotShadowColor = color2;
        if (Carbon.IS_PIE_OR_HIGHER) {
            super.setOutlineSpotShadowColor(color2.getColorForState(this.getDrawableState(), color2.getDefaultColor()));
        } else {
            this.setElevation(this.elevation);
            this.setTranslationZ(this.translationZ);
        }
    }

    @Override
    public int getOutlineSpotShadowColor() {
        return this.spotShadowColor.getDefaultColor();
    }

    @Override
    public void setTouchMargin(int left, int top, int right, int bottom) {
        this.touchMargin.set(left, top, right, bottom);
    }

    @Override
    public void setTouchMarginLeft(int margin) {
        this.touchMargin.left = margin;
    }

    @Override
    public void setTouchMarginTop(int margin) {
        this.touchMargin.top = margin;
    }

    @Override
    public void setTouchMarginRight(int margin) {
        this.touchMargin.right = margin;
    }

    @Override
    public void setTouchMarginBottom(int margin) {
        this.touchMargin.bottom = margin;
    }

    @Override
    @NotNull
    public Rect getTouchMargin() {
        return this.touchMargin;
    }

    public void getHitRect(@NonNull Rect outRect) {
        Matrix matrix = this.getMatrix();
        if (matrix.isIdentity()) {
            outRect.set(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        } else {
            this.tmpHitRect.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            matrix.mapRect(this.tmpHitRect);
            outRect.set((int)this.tmpHitRect.left + this.getLeft(), (int)this.tmpHitRect.top + this.getTop(), (int)this.tmpHitRect.right + this.getLeft(), (int)this.tmpHitRect.bottom + this.getTop());
        }
        outRect.left -= this.touchMargin.left;
        outRect.top -= this.touchMargin.top;
        outRect.right += this.touchMargin.right;
        outRect.bottom += this.touchMargin.bottom;
    }

    @Override
    @NotNull
    public StateAnimator getStateAnimator() {
        return this.stateAnimator;
    }

    protected void drawableStateChanged() {
        ColorStateList textColors;
        super.drawableStateChanged();
        if (this.rippleDrawable != null && this.rippleDrawable.getStyle() != RippleDrawable.Style.Background) {
            this.rippleDrawable.setState(this.getDrawableState());
        }
        if (this.stateAnimator != null) {
            this.stateAnimator.setState(this.getDrawableState());
        }
        if ((textColors = this.getTextColors()) instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)textColors).setState(this.getDrawableState());
        }
        if (this.tint != null && this.tint instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.tint).setState(this.getDrawableState());
        }
        if (this.backgroundTint != null && this.backgroundTint instanceof AnimatedColorStateList) {
            ((AnimatedColorStateList)this.backgroundTint).setState(this.getDrawableState());
        }
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (!this.isValid()) {
            int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
            TextView.mergeDrawableStates((int[])drawableState, (int[])INVALID_STATE_SET);
            return drawableState;
        }
        return super.onCreateDrawableState(extraSpace);
    }

    @Override
    public Animator animateVisibility(final int visibility) {
        if (visibility == 0 && (this.getVisibility() != 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.inAnim != null) {
                this.animator = this.inAnim;
                this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        TextView.this.animator = null;
                    }

                    public void onAnimationCancel(Animator a) {
                        a.removeListener((Animator.AnimatorListener)this);
                        TextView.this.animator = null;
                    }
                });
                this.animator.start();
            }
            this.setVisibility(visibility);
        } else if (visibility != 0 && (this.getVisibility() == 0 || this.animator != null)) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.outAnim == null) {
                this.setVisibility(visibility);
                return null;
            }
            this.animator = this.outAnim;
            this.animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator a) {
                    if (((ValueAnimator)a).getAnimatedFraction() == 1.0f) {
                        TextView.this.setVisibility(visibility);
                    }
                    a.removeListener((Animator.AnimatorListener)this);
                    TextView.this.animator = null;
                }

                public void onAnimationCancel(Animator a) {
                    a.removeListener((Animator.AnimatorListener)this);
                    TextView.this.animator = null;
                }
            });
            this.animator.start();
        } else {
            this.setVisibility(visibility);
        }
        return this.animator;
    }

    @Override
    public Animator getAnimator() {
        return this.animator;
    }

    @Override
    public Animator getOutAnimator() {
        return this.outAnim;
    }

    @Override
    public void setOutAnimator(Animator outAnim) {
        if (this.outAnim != null) {
            this.outAnim.setTarget(null);
        }
        this.outAnim = outAnim;
        if (outAnim != null) {
            outAnim.setTarget((Object)this);
        }
    }

    @Override
    public Animator getInAnimator() {
        return this.inAnim;
    }

    @Override
    public void setInAnimator(Animator inAnim) {
        if (this.inAnim != null) {
            this.inAnim.setTarget(null);
        }
        this.inAnim = inAnim;
        if (inAnim != null) {
            inAnim.setTarget((Object)this);
        }
    }

    @Override
    public void setTintList(ColorStateList list) {
        this.tint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.tintAnimatorListener) : list);
        this.applyTint();
    }

    @Override
    public void setTint(int color2) {
        this.setTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getTint() {
        return this.tint;
    }

    protected void updateTint() {
        Drawable[] drawables = this.getCompoundDrawables();
        if (this.tint != null && this.tintMode != null) {
            for (Drawable drawable2 : drawables) {
                if (drawable2 == null) continue;
                drawable2.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tint.getColorForState(this.getDrawableState(), this.tint.getDefaultColor()), this.tintMode));
            }
        }
    }

    protected void applyTint() {
        Drawable[] drawables = this.getCompoundDrawables();
        if (this.tint != null && this.tintMode != null) {
            for (Drawable drawable2 : drawables) {
                if (drawable2 == null) continue;
                Carbon.setTintListMode(drawable2, this.tint, this.tintMode);
                if (!drawable2.isStateful()) continue;
                drawable2.setState(this.getDrawableState());
            }
        } else {
            for (Drawable drawable3 : drawables) {
                if (drawable3 == null) continue;
                Carbon.clearTint(drawable3);
                if (!drawable3.isStateful()) continue;
                drawable3.setState(this.getDrawableState());
            }
        }
    }

    @Override
    public void setTintMode(@NonNull PorterDuff.Mode mode) {
        this.tintMode = mode;
        this.applyTint();
    }

    @Override
    public PorterDuff.Mode getTintMode() {
        return this.tintMode;
    }

    @Override
    public void setBackgroundTintList(ColorStateList list) {
        this.backgroundTint = list == null ? null : (this.animateColorChanges && !(list instanceof AnimatedColorStateList) ? AnimatedColorStateList.fromList(list, this.backgroundTintAnimatorListener) : list);
        this.applyBackgroundTint();
    }

    @Override
    public void setBackgroundTint(int color2) {
        this.setBackgroundTintList(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getBackgroundTint() {
        return this.backgroundTint;
    }

    protected void updateBackgroundTint() {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable) {
            background = ((RippleDrawable)background).getBackground();
        }
        if (background != null && this.backgroundTint != null && this.backgroundTintMode != null) {
            background.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.backgroundTint.getColorForState(this.getDrawableState(), this.backgroundTint.getDefaultColor()), this.backgroundTintMode));
        }
    }

    protected void applyBackgroundTint() {
        Drawable background = this.getBackground();
        if (background instanceof RippleDrawable) {
            background = ((RippleDrawable)background).getBackground();
        }
        if (background == null) {
            return;
        }
        if (this.backgroundTint != null && this.backgroundTintMode != null) {
            Carbon.setTintListMode(background, this.backgroundTint, this.backgroundTintMode);
        } else {
            Carbon.clearTint(background);
        }
        if (background.isStateful()) {
            background.setState(this.getDrawableState());
        }
    }

    @Override
    public void setBackgroundTintMode(@Nullable PorterDuff.Mode mode) {
        this.backgroundTintMode = mode;
        this.applyBackgroundTint();
    }

    @Override
    public PorterDuff.Mode getBackgroundTintMode() {
        return this.backgroundTintMode;
    }

    @Override
    public boolean isAnimateColorChangesEnabled() {
        return this.animateColorChanges;
    }

    @Override
    public void setAnimateColorChangesEnabled(boolean animateColorChanges) {
        if (this.animateColorChanges == animateColorChanges) {
            return;
        }
        this.animateColorChanges = animateColorChanges;
        this.setTintList(this.tint);
        this.setBackgroundTintList(this.backgroundTint);
        this.setTextColor(this.getTextColors());
    }

    private void drawStroke(Canvas canvas) {
        this.strokePaint.setStrokeWidth(this.strokeWidth * 2.0f);
        this.strokePaint.setColor(this.stroke.getColorForState(this.getDrawableState(), this.stroke.getDefaultColor()));
        this.cornersMask.setFillType(Path.FillType.WINDING);
        canvas.drawPath(this.cornersMask, this.strokePaint);
    }

    @Override
    public void setStroke(ColorStateList colorStateList) {
        this.stroke = colorStateList;
        if (this.stroke == null) {
            return;
        }
        if (this.strokePaint == null) {
            this.strokePaint = new Paint(1);
            this.strokePaint.setStyle(Paint.Style.STROKE);
        }
    }

    @Override
    public void setStroke(int color2) {
        this.setStroke(ColorStateList.valueOf((int)color2));
    }

    @Override
    public ColorStateList getStroke() {
        return this.stroke;
    }

    @Override
    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
    }

    @Override
    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.requestLayout();
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        this.requestLayout();
    }

    protected void onMeasure2(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getMeasuredWidth() > this.maxWidth || this.getMeasuredHeight() > this.maxHeight) {
            if (this.getMeasuredWidth() > this.maxWidth) {
                widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)0x40000000);
            }
            if (this.getMeasuredHeight() > this.maxHeight) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)0x40000000);
            }
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    @Override
    @NonNull
    public AutoSizeTextMode getAutoSizeText() {
        return this.autoSizeText;
    }

    @Override
    public void setAutoSizeText(@NonNull AutoSizeTextMode autoSizeText) {
        this.autoSizeText = autoSizeText;
        this.adjustTextSize();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        this.fixSpannableEllipsis();
        this.adjustTextSize();
    }

    @Override
    public void setTextSize(float size) {
        super.setTextSize(size);
        this.adjustTextSize();
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        super.setEllipsize(where);
        this.fixSpannableEllipsis();
    }

    public void setMaxLines(int maxLines) {
        super.setMaxLines(maxLines);
        this.fixSpannableEllipsis();
        this.maxLines = maxLines;
        this.adjustTextSize();
    }

    public void setSingleLine() {
        super.setSingleLine();
        this.adjustTextSize();
    }

    public void setSingleLine(boolean singleLine) {
        super.setSingleLine(singleLine);
        if (!singleLine) {
            super.setMaxLines(-1);
        }
        this.adjustTextSize();
    }

    public void setGravity(int gravity) {
        super.setGravity(gravity);
        this.fixSpannableEllipsis();
    }

    public void setLines(int lines) {
        super.setLines(lines);
        this.adjustTextSize();
    }

    public void setTextSize(int unit, float size) {
        super.setTextSize(unit, size);
        this.adjustTextSize();
    }

    public void setLineSpacing(float add, float mult) {
        super.setLineSpacing(add, mult);
        this.spacingMult = mult;
        this.spacingAdd = add;
    }

    private void initAutoSize() {
        if (this.autoSizeText == AutoSizeTextMode.Uniform && this.minTextSize > 0.0f && this.maxTextSize > 0.0f) {
            this.autoSizeStepPresets = new float[(int)Math.ceil((this.maxTextSize - this.minTextSize) / this.autoSizeStepGranularity) + 1];
            for (int i = 0; i < this.autoSizeStepPresets.length - 1; ++i) {
                this.autoSizeStepPresets[i] = this.minTextSize + this.autoSizeStepGranularity * (float)i;
            }
            this.autoSizeStepPresets[this.autoSizeStepPresets.length - 1] = this.maxTextSize;
        }
    }

    @Override
    public float getMinTextSize() {
        return this.minTextSize;
    }

    @Override
    public void setMinTextSize(float minTextSize) {
        this.minTextSize = minTextSize;
        this.autoSizeStepPresets = null;
        this.adjustTextSize();
    }

    @Override
    public float getMaxTextSize() {
        return this.maxTextSize;
    }

    @Override
    public int getAutoSizeStepGranularity() {
        return (int)this.autoSizeStepGranularity;
    }

    @Override
    public void setAutoSizeStepGranularity(int autoSizeStepGranularity) {
        this.setAutoSizeStepGranularity((float)autoSizeStepGranularity);
    }

    @Override
    public void setAutoSizeStepGranularity(float autoSizeStepGranularity) {
        this.autoSizeStepGranularity = autoSizeStepGranularity;
        this.autoSizeStepPresets = null;
        this.adjustTextSize();
    }

    @Override
    public void setMaxTextSize(float maxTextSize) {
        this.maxTextSize = maxTextSize;
        this.autoSizeStepPresets = null;
        this.adjustTextSize();
    }

    private void adjustTextSize() {
        if (this.autoSizeText == AutoSizeTextMode.None || this.minTextSize <= 0.0f || this.maxTextSize <= 0.0f || this.getMeasuredWidth() == 0 || this.getMeasuredHeight() == 0) {
            return;
        }
        if (this.autoSizeStepPresets == null) {
            this.initAutoSize();
        }
        this.availableSpaceRect.right = this.getMeasuredWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        this.availableSpaceRect.bottom = this.getMeasuredHeight() - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
        super.setTextSize(0, this.binarySearch(this.availableSpaceRect));
    }

    private float binarySearch(RectF availableSpace) {
        int lastBest = 0;
        int lo = 0;
        int hi = this.autoSizeStepPresets.length - 1;
        while (lo <= hi) {
            int mid = (lo + hi) / 2;
            boolean fits = this.testSize(this.autoSizeStepPresets[mid], availableSpace);
            if (fits) {
                lastBest = mid;
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return this.autoSizeStepPresets[lastBest];
    }

    public boolean testSize(float suggestedSize, RectF availableSpace) {
        this.paint.setTextSize(suggestedSize);
        this.paint.setTypeface(this.getTypeface());
        String text = this.getText().toString();
        if (this.maxLines == 1) {
            this.textRect.bottom = this.paint.getFontSpacing();
            this.textRect.right = this.paint.measureText(text);
            return availableSpace.width() >= this.textRect.right && availableSpace.height() >= this.textRect.bottom;
        }
        StaticLayout layout2 = new StaticLayout((CharSequence)text, this.paint, (int)availableSpace.right, Layout.Alignment.ALIGN_NORMAL, this.spacingMult, this.spacingAdd, true);
        if (this.maxLines != -1 && layout2.getLineCount() > this.maxLines) {
            return false;
        }
        return availableSpace.width() >= (float)layout2.getWidth() && availableSpace.height() >= (float)layout2.getHeight();
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        super.onTextChanged(text, start, before, after);
        this.adjustTextSize();
    }

    protected void onSizeChanged(int width, int height, int oldwidth, int oldheight) {
        super.onSizeChanged(width, height, oldwidth, oldheight);
        if (width != oldwidth || height != oldheight) {
            this.adjustTextSize();
        }
    }

    public void addOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.add(listener);
    }

    public void removeOnTransformationChangedListener(OnTransformationChangedListener listener) {
        this.transformationChangedListeners.remove(listener);
    }

    public void clearOnTransformationChangedListeners() {
        this.transformationChangedListeners.clear();
    }

    private void fireOnTransformationChangedListener() {
        if (this.transformationChangedListeners == null) {
            return;
        }
        for (OnTransformationChangedListener listener : this.transformationChangedListeners) {
            listener.onTransformationChanged();
        }
    }

    public void setRotation(float rotation) {
        super.setRotation(rotation);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationY(float rotationY) {
        super.setRotationY(rotationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setRotationX(float rotationX) {
        super.setRotationX(rotationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleX(float scaleX) {
        super.setScaleX(scaleX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setScaleY(float scaleY) {
        super.setScaleY(scaleY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotX(float pivotX) {
        super.setPivotX(pivotX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setPivotY(float pivotY) {
        super.setPivotY(pivotY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setAlpha(@FloatRange(from=0.0, to=1.0) float alpha) {
        super.setAlpha(alpha);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationX(float translationX) {
        super.setTranslationX(translationX);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        this.invalidateParentIfNeeded();
        this.fireOnTransformationChangedListener();
    }

    public void setWidth(int width) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, -2));
        } else {
            layoutParams.width = width;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setHeight(int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(-2, height));
        } else {
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            this.setLayoutParams(new ViewGroup.LayoutParams(width, height));
        } else {
            layoutParams.width = width;
            layoutParams.height = height;
            this.setLayoutParams(layoutParams);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setSize(width, height);
        this.setTranslationX(x);
        this.setTranslationY(y);
    }

    public void setTooltipText(CharSequence text) {
        if (text != null) {
            this.setOnLongClickListener(v -> {
                Label tooltip = (Label)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.carbon_tooltip, null);
                tooltip.setText(text);
                PopupWindow window = new PopupWindow(tooltip);
                window.show((View)this, 51);
                new Handler(Looper.getMainLooper()).postDelayed(window::dismiss, 3000L);
                return true;
            });
        } else if (this.isLongClickable()) {
            this.setOnLongClickListener(null);
        }
    }
}

