/*
 * Decompiled with CFR 0.152.
 */
package carbon.widget;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.animation.DecelerateInterpolator;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.viewpager.widget.ViewPager;
import carbon.R;
import carbon.view.View;
import carbon.widget.ViewPager;

public class ViewPagerIndicator
extends View {
    ViewPager viewPager;
    private Paint paint = new Paint(1);
    private float indicatorPos = 0.0f;
    private int selectedPage = 0;
    DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator();
    private ValueAnimator animator;
    private ViewPager.OnPageChangeListener pageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            if ((position = Math.round((float)position + positionOffset)) != ViewPagerIndicator.this.selectedPage) {
                if (ViewPagerIndicator.this.animator != null) {
                    ViewPagerIndicator.this.animator.cancel();
                }
                ViewPagerIndicator.this.animator = ValueAnimator.ofFloat((float[])new float[]{ViewPagerIndicator.this.indicatorPos, position});
                ViewPagerIndicator.this.animator.setDuration(200L);
                if (position > ViewPagerIndicator.this.selectedPage) {
                    ViewPagerIndicator.this.animator.setStartDelay(100L);
                }
                ViewPagerIndicator.this.animator.setInterpolator((TimeInterpolator)ViewPagerIndicator.this.decelerateInterpolator);
                ViewPagerIndicator.this.animator.addUpdateListener(animation -> {
                    ViewPagerIndicator.this.indicatorPos = ((Float)animation.getAnimatedValue()).floatValue();
                    ViewPagerIndicator.this.postInvalidate();
                });
                ViewPagerIndicator.this.animator.start();
                ViewPagerIndicator.this.selectedPage = position;
            }
        }

        public void onPageSelected(int position) {
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    public ViewPagerIndicator(Context context) {
        super(context, null, R.attr.carbon_viewPagerIndicatorStyle);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.carbon_viewPagerIndicatorStyle);
    }

    public ViewPagerIndicator(Context context, AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ViewPagerIndicator(Context context, AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager != null) {
            viewPager.removeOnPageChangeListener(this.pageChangeListener);
        }
        this.viewPager = viewPager;
        if (viewPager != null) {
            viewPager.addOnPageChangeListener(this.pageChangeListener);
        }
    }

    public ViewPager getViewPager() {
        return this.viewPager;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        int pages = this.viewPager != null && this.viewPager.getAdapter() != null ? this.viewPager.getAdapter().getCount() : 5;
        this.paint.setStyle(Paint.Style.STROKE);
        float radius = (float)this.getHeight() / 2.0f - 1.0f;
        if (pages > 1) {
            int[] nArray;
            int color2 = this.getTint().getColorForState(new int[]{this.isEnabled() ? 16842910 : -16842910}, this.getTint().getDefaultColor());
            this.paint.setColor(color2);
            for (int i = 0; i < pages; ++i) {
                canvas.drawCircle((float)this.getHeight() / 2.0f + (float)((this.getWidth() - this.getHeight()) * i / (pages - 1)), (float)this.getHeight() / 2.0f, radius, this.paint);
            }
            this.paint.setStyle(Paint.Style.FILL);
            ColorStateList colorStateList = this.getTint();
            if (this.isEnabled()) {
                int[] nArray2 = new int[2];
                nArray2[0] = 0x10100A1;
                nArray = nArray2;
                nArray2[1] = 16842910;
            } else {
                int[] nArray3 = new int[1];
                nArray = nArray3;
                nArray3[0] = -16842913;
            }
            color2 = colorStateList.getColorForState(nArray, this.getTint().getDefaultColor());
            this.paint.setColor(color2);
            float frac = (float)((double)this.indicatorPos - Math.floor(this.indicatorPos));
            this.paint.setAlpha((int)((1.0f - frac) * (float)Color.alpha((int)color2)));
            canvas.drawCircle((float)((double)((float)this.getHeight() / 2.0f) + (double)(this.getWidth() - this.getHeight()) * Math.floor(this.indicatorPos) / (double)(pages - 1)), (float)this.getHeight() / 2.0f, radius, this.paint);
            this.paint.setAlpha((int)(frac * (float)Color.alpha((int)color2)));
            canvas.drawCircle((float)((double)((float)this.getHeight() / 2.0f) + (double)(this.getWidth() - this.getHeight()) * Math.ceil(this.indicatorPos) / (double)(pages - 1)), (float)this.getHeight() / 2.0f, radius, this.paint);
        } else {
            int color3 = this.getTint().getColorForState(new int[0x10100A1], this.getTint().getDefaultColor());
            this.paint.setColor(color3);
            this.paint.setStyle(Paint.Style.FILL);
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, radius, this.paint);
        }
    }
}

