/*
 * Decompiled with CFR 0.152.
 */
package to.etc.event.local;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import to.etc.event.local.ILocalEventListener;

public class LocalEventManager {
    private static final LocalEventManager m_instance = new LocalEventManager();
    @Nonnull
    @GuardedBy(value="this")
    private final Map<Class<?>, List<ILocalEventListener<?>>> m_listeners = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addListenerForEvent(@Nonnull ILocalEventListener<T> l, @Nonnull Class<? extends T> eventClass) {
        List<ILocalEventListener<?>> existingListeners;
        LocalEventManager localEventManager = this;
        synchronized (localEventManager) {
            existingListeners = this.m_listeners.get(eventClass);
        }
        ArrayList<Object> newListeners = existingListeners == null ? new ArrayList() : new ArrayList(existingListeners);
        newListeners.add(l);
        LocalEventManager localEventManager2 = this;
        synchronized (localEventManager2) {
            this.m_listeners.put(eventClass, newListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void eventFired(@Nonnull T firedEvent) throws Exception {
        List<ILocalEventListener<?>> listeners;
        LocalEventManager localEventManager = this;
        synchronized (localEventManager) {
            listeners = this.m_listeners.get(firedEvent.getClass());
        }
        if (listeners == null) {
            return;
        }
        for (ILocalEventListener iLocalEventListener : listeners) {
            iLocalEventListener.eventFired(firedEvent);
        }
    }

    public static LocalEventManager getInstance() {
        return m_instance;
    }
}

