/*
 * Decompiled with CFR 0.152.
 */
package to.etc.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class DirWalker {
    private DirWalker() {
    }

    @Nullable
    public static <T> T scan(@Nonnull File srcdir, @Nonnull IEntry<T> handler) throws Exception {
        StringBuilder sb = new StringBuilder();
        return DirWalker.scanInternal(srcdir, handler, sb);
    }

    @Nullable
    private static <T> T scanInternal(@Nonnull File srcdir, @Nonnull IEntry<T> handler, @Nonnull StringBuilder sb) throws Exception {
        File[] ar = srcdir.listFiles();
        if (ar == null) {
            return null;
        }
        int len = sb.length();
        for (File f : ar) {
            sb.setLength(len);
            if (len > 0) {
                sb.append('/');
            }
            sb.append(f.getName());
            String name = sb.toString();
            T res = handler.onEntry(f, name);
            if (null != res) {
                return res;
            }
            if (!f.isDirectory()) continue;
            res = DirWalker.scanInternal(f, handler, sb);
        }
        return null;
    }

    @Nonnull
    public static List<File> dir(@Nonnull File srcdir, boolean files, boolean dirs) throws Exception {
        if (!files && !dirs) {
            throw new IllegalArgumentException("Looking for nothing is not useful");
        }
        ArrayList<File> res = new ArrayList<File>();
        DirWalker.dir(res, srcdir, files, dirs);
        return res;
    }

    private static void dir(@Nonnull List<File> res, @Nonnull File srcdir, boolean files, boolean dirs) throws Exception {
        File[] ar = srcdir.listFiles();
        if (null == ar) {
            return;
        }
        for (File f : ar) {
            if (files && dirs) {
                res.add(f);
            } else if (files && f.isFile()) {
                res.add(f);
            } else if (dirs && f.isDirectory()) {
                res.add(f);
            }
            if (!f.isDirectory()) continue;
            DirWalker.dir(res, f, files, dirs);
        }
    }

    public static interface IEntry<T> {
        @Nullable
        public T onEntry(@Nonnull File var1, @Nonnull String var2) throws Exception;
    }
}

