/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonWriter;

public abstract class AbstractJsonArrayType
implements ITypeMapping {
    @Nonnull
    private final ITypeMapping m_memberMapping;

    @Nonnull
    protected abstract Iterator<Object> getIterator(@Nonnull Object var1);

    @Nonnull
    protected abstract Collection<?> createInstance() throws Exception;

    protected AbstractJsonArrayType(@Nonnull ITypeMapping memberMapping) {
        this.m_memberMapping = memberMapping;
    }

    @Nonnull
    public static Class<? extends Collection<?>> getImplementationClass(@Nonnull Class<?> typeClass, @Nonnull Class<?> defaultImplementation) {
        int mod = typeClass.getModifiers();
        if (!Modifier.isAbstract(mod) && Modifier.isPublic(mod) && !Modifier.isInterface(mod)) {
            return typeClass;
        }
        return defaultImplementation;
    }

    @Override
    public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
        Collection coll = (Collection)instance;
        w.write(91);
        w.inc();
        int ct = 0;
        Iterator<Object> it = this.getIterator(instance);
        while (it.hasNext()) {
            Object o = it.next();
            if (ct++ > 0) {
                w.write(44);
            } else if (ct % 10 == 0) {
                w.nl();
            }
            if (null == o) {
                w.write("null");
                continue;
            }
            this.m_memberMapping.render(w, o);
        }
        w.dec();
        w.write("]");
    }

    @Override
    public Object parse(@Nonnull JsonReader reader) throws Exception {
        if (reader.getLastToken() == -5) {
            if ("null".equalsIgnoreCase(reader.getCopied())) {
                reader.nextToken();
                return null;
            }
        } else if (reader.getLastToken() == 91) {
            reader.nextToken();
            return this.parseList(reader);
        }
        throw new JsonParseException(reader, this, "Expecting a json array '[' but got " + reader.getTokenString());
    }

    private Object parseList(@Nonnull JsonReader reader) throws Exception {
        int token;
        Collection<Object> collection = this.createInstance();
        while ((token = reader.getLastToken()) != 93) {
            if (token == -1) {
                throw new JsonParseException(reader, this, "Unexpected eof while parsing json array");
            }
            Object value = this.m_memberMapping.parse(reader);
            collection.add(value);
            token = reader.getLastToken();
            if (token == 44) {
                reader.nextToken();
                continue;
            }
            if (token == 93) break;
            throw new JsonParseException(reader, this, "Expecting either ] or , but got " + reader.getTokenString());
        }
        reader.nextToken();
        return this.convertResult(collection);
    }

    protected Object convertResult(@Nonnull Collection<Object> res) throws Exception {
        return res;
    }
}

