/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;

public final class JSON {
    @Nonnull
    private static JsonTypeRegistry m_registry = new JsonTypeRegistry();

    private JSON() {
    }

    @Nonnull
    public static JsonTypeRegistry getRegistry() {
        return m_registry;
    }

    public static <T> T decode(@Nonnull Class<T> typeClass, @Nonnull Reader input) throws Exception {
        JsonReader reader = new JsonReader("input", input, m_registry);
        return reader.parse(typeClass, null);
    }

    public static <T> T decode(@Nonnull Class<T> typeClass, @Nonnull Type type, @Nonnull Reader input) throws Exception {
        JsonReader reader = new JsonReader("input", input, m_registry);
        return reader.parse(typeClass, type);
    }

    public static <T> void render(@Nonnull Writer writer, @Nullable T instance) throws Exception {
        JSON.render(writer, instance, null);
    }

    public static <T> void render(@Nonnull Writer writer, @Nullable T instance, @Nullable Type fullType) throws Exception {
        JsonWriter w = writer instanceof JsonWriter ? (JsonWriter)writer : new JsonWriter(writer, m_registry);
        w.render(instance, fullType);
    }

    @Nonnull
    public static <T> String render(@Nullable T instance, @Nullable Type fullType) throws Exception {
        StringWriter sw = new StringWriter();
        JsonWriter w = new JsonWriter(sw, m_registry);
        w.render(instance, fullType);
        return sw.getBuffer().toString();
    }

    @Nonnull
    public static <T> String render(@Nullable T instance) throws Exception {
        return JSON.render(instance, null);
    }
}

