/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonArrayType;
import to.etc.json.JsonTypeRegistry;
import to.etc.util.ClassUtil;

public class JsonArrayFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (!typeClass.isArray()) {
            return null;
        }
        Class<?> memberType = ClassUtil.findCollectionType(typeClass);
        if (null == memberType || Object.class == memberType) {
            return null;
        }
        int mod = memberType.getModifiers();
        if (Modifier.isAbstract(mod) || Modifier.isInterface(mod) || !Modifier.isPublic(mod)) {
            return null;
        }
        ITypeMapping memberMapping = registry.createMapping(memberType, null);
        if (null == memberMapping) {
            return null;
        }
        return new JsonArrayType(memberMapping, memberType);
    }
}

