/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import to.etc.json.AbstractJsonArrayType;
import to.etc.json.ITypeMapping;
import to.etc.util.ArrayIterator;

public class JsonArrayType
extends AbstractJsonArrayType
implements ITypeMapping {
    @Nonnull
    private final Class<?> m_implementationType;

    public JsonArrayType(@Nonnull ITypeMapping memberMapping, @Nonnull Class<?> memberClass) {
        super(memberMapping);
        this.m_implementationType = memberClass;
    }

    @Nonnull
    public static Class<? extends Collection<?>> getImplementationClass(@Nonnull Class<?> typeClass, @Nonnull Class<?> defaultImplementation) {
        int mod = typeClass.getModifiers();
        if (!Modifier.isAbstract(mod) && Modifier.isPublic(mod) && !Modifier.isInterface(mod)) {
            return typeClass;
        }
        return defaultImplementation;
    }

    @Override
    @Nonnull
    protected Collection<?> createInstance() throws Exception {
        return new ArrayList();
    }

    @Override
    @Nonnull
    protected Iterator<Object> getIterator(@Nonnull Object instance) {
        return new ArrayIterator<Object>((Object[])instance);
    }

    @Override
    protected Object convertResult(@Nonnull Collection<Object> res) throws Exception {
        Object[] val = (Object[])Array.newInstance(this.m_implementationType, res.size());
        int index = 0;
        for (Object o : res) {
            val[index++] = o;
        }
        return val;
    }
}

