/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonWriter;
import to.etc.json.PropertyMapping;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;

public class JsonClassType<T>
implements ITypeMapping {
    private Class<T> m_rootClass;
    private Map<String, PropertyMapping> m_map;

    public JsonClassType(@Nonnull Class<T> rootClass) {
        this.m_rootClass = rootClass;
    }

    @Override
    public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
        w.write("{");
        w.nl();
        w.inc();
        int ct = 0;
        for (PropertyMapping pm : this.m_map.values()) {
            Object value;
            try {
                value = pm.getGetter().invoke(instance, new Object[0]);
            }
            catch (Exception x) {
                Exception nx = WrappedException.unwrap(x);
                throw new RuntimeException("JSON encode failed for " + pm.getName() + ": " + nx, nx);
            }
            if (null == value) continue;
            if (ct++ > 0) {
                w.write(",");
            }
            w.append(pm.getName());
            w.append(':');
            pm.getMapper().render(w, value);
            w.nl();
        }
        w.dec();
        w.write("}");
    }

    @Override
    public Object parse(@Nonnull JsonReader reader) throws Exception {
        if (reader.getLastToken() != 123) {
            throw new JsonParseException(reader, this, "Expecting '{' but got " + reader.getLastToken());
        }
        reader.nextToken();
        T instance = this.m_rootClass.newInstance();
        while (true) {
            String name;
            int token;
            if ((token = reader.getLastToken()) == -1) {
                throw new JsonParseException(reader, this, "Unexpected eof");
            }
            if (token == 125) break;
            if (token == -5) {
                name = reader.getCopied();
            } else if (token == -2) {
                name = StringTool.strUnquote(reader.getCopied());
            } else {
                throw new JsonParseException(reader, this, "Expecting a property name, got " + (char)token);
            }
            PropertyMapping pm = this.m_map.get(name);
            if (null == pm) {
                throw new JsonParseException(reader, this, "JSON property '" + name + "' is not mapped on class " + this.m_rootClass.getName());
            }
            token = reader.nextToken();
            if (token != 58) {
                throw new JsonParseException(reader, this, "Missing ':' after property " + name);
            }
            reader.nextToken();
            Object value = pm.getMapper().parse(reader);
            Method setter = pm.getSetter();
            if (null != setter) {
                try {
                    value = setter.invoke(instance, value);
                }
                catch (Exception x) {
                    Exception nx = WrappedException.unwrap(x);
                    throw new RuntimeException("JSON decode failed for " + pm.getName() + " value " + value + ": " + nx, nx);
                }
            }
            if ((token = reader.getLastToken()) == 125) break;
            if (token != 44) {
                throw new JsonParseException(reader, this, "Missing ',' after property:value " + name);
            }
            reader.nextToken();
        }
        reader.nextToken();
        return instance;
    }

    public void setMap(@Nonnull Map<String, PropertyMapping> res) {
        this.m_map = res;
    }
}

