/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;
import to.etc.util.StringTool;

public class JsonEnumFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, final @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (!Enum.class.isAssignableFrom(typeClass)) {
            return null;
        }
        return new ITypeMapping(){

            @Override
            public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
                Enum en = (Enum)instance;
                w.writeString(en.name());
            }

            @Override
            public Object parse(@Nonnull JsonReader reader) throws Exception {
                if (reader.getLastToken() != -2) {
                    throw new JsonParseException(reader, this, "Expecting a string (enum " + typeClass.getName() + ") but got " + reader.getTokenString());
                }
                String val = StringTool.strUnquote(reader.getCopied());
                Class enc = typeClass;
                reader.nextToken();
                for (Enum ec : (Enum[])enc.getEnumConstants()) {
                    if (!ec.name().equals(val)) continue;
                    return ec;
                }
                throw new JsonParseException(reader, this, "Enum value '" + val + "' not valid for " + typeClass);
            }
        };
    }
}

