/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonArrayFactory;
import to.etc.json.JsonBooleanFactory;
import to.etc.json.JsonClassType;
import to.etc.json.JsonEnumFactory;
import to.etc.json.JsonIntFactory;
import to.etc.json.JsonListFactory;
import to.etc.json.JsonLongFactory;
import to.etc.json.JsonSetFactory;
import to.etc.json.JsonStringFactory;
import to.etc.json.JsonUtcDateFactory;
import to.etc.json.PropertyMapping;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;

public class JsonTypeRegistry {
    private Map<Class<?>, ITypeMapping> m_classMap = new HashMap();
    private Set<Entry> m_list = new TreeSet<Entry>(new Comparator<Entry>(){

        @Override
        public int compare(Entry a, Entry b) {
            int ct = a.getOrder() - b.getOrder();
            if (ct != 0) {
                return ct;
            }
            return a.hashCode() - b.hashCode();
        }
    });
    private static Set<String> IGNORESET = new HashSet<String>(Arrays.asList("class"));

    public JsonTypeRegistry() {
        this.register(1000, new JsonIntFactory());
        this.register(1000, new JsonStringFactory());
        this.register(1000, new JsonLongFactory());
        this.register(1000, new JsonBooleanFactory());
        this.register(1000, new JsonUtcDateFactory());
        this.register(1000, new JsonEnumFactory());
        this.register(1000, new JsonListFactory());
        this.register(1000, new JsonSetFactory());
        this.register(1000, new JsonArrayFactory());
    }

    public synchronized void register(int order, @Nonnull IJsonTypeFactory factory) {
        this.m_list.add(new Entry(order, factory));
    }

    @Nullable
    public synchronized ITypeMapping findFactory(@Nonnull Class<?> typeClass, @Nullable Type type) {
        for (Entry e : this.m_list) {
            ITypeMapping mapper = e.getFactory().createMapper(this, typeClass, type);
            if (null == mapper) continue;
            return mapper;
        }
        return null;
    }

    @Nullable
    public synchronized <T> ITypeMapping createMapping(@Nonnull Class<T> clz, @Nullable Type type) {
        ITypeMapping cm = this.m_classMap.get(clz);
        if (null != cm) {
            return cm;
        }
        ITypeMapping tm = this.findFactory(clz, type);
        if (null != tm) {
            return tm;
        }
        if (clz.isPrimitive()) {
            throw new IllegalStateException("No renderer for " + clz);
        }
        JsonClassType<T> ct = new JsonClassType<T>(clz);
        this.m_classMap.put(clz, ct);
        List<PropertyInfo> props = ClassUtil.calculateProperties(clz);
        TreeMap<String, PropertyMapping> res = new TreeMap<String, PropertyMapping>();
        for (PropertyInfo pi : props) {
            PropertyMapping pm;
            if (IGNORESET.contains(pi.getName()) || null == (pm = this.createPropertyMapper(clz, pi))) continue;
            res.put(pm.getName(), pm);
        }
        ct.setMap(res);
        return ct;
    }

    @Nullable
    private <T> PropertyMapping createPropertyMapper(@Nonnull Class<T> type, @Nonnull PropertyInfo pi) {
        try {
            ITypeMapping pm = this.createMapping(pi.getActualType(), pi.getActualGenericType());
            if (null == pm) {
                return null;
            }
            return new PropertyMapping(pi.getGetter(), pi.getSetter(), pi.getName(), pm);
        }
        catch (Exception x) {
            throw new RuntimeException("In mapping " + pi.getName() + " of class " + type.getName() + ": " + x, x);
        }
    }

    private static class Entry {
        private final int m_order;
        @Nonnull
        private final IJsonTypeFactory m_factory;

        public Entry(int order, @Nonnull IJsonTypeFactory factory) {
            this.m_order = order;
            this.m_factory = factory;
        }

        public int getOrder() {
            return this.m_order;
        }

        @Nonnull
        public IJsonTypeFactory getFactory() {
            return this.m_factory;
        }
    }
}

