/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.lang.reflect.Type;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.IJsonTypeFactory;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonParseException;
import to.etc.json.JsonReader;
import to.etc.json.JsonTypeRegistry;
import to.etc.json.JsonWriter;

public class JsonUtcDateFactory
implements IJsonTypeFactory {
    @Override
    public ITypeMapping createMapper(@Nonnull JsonTypeRegistry registry, @Nonnull Class<?> typeClass, @Nullable Type type) {
        if (Date.class.isAssignableFrom(typeClass)) {
            return new ITypeMapping(){

                @Override
                public void render(@Nonnull JsonWriter w, @Nonnull Object instance) throws Exception {
                    Date dt = (Date)instance;
                    w.writeLong(dt.getTime());
                }

                @Override
                public Object parse(@Nonnull JsonReader reader) throws Exception {
                    if (reader.getLastToken() != -3) {
                        throw new JsonParseException(reader, this, "Expecting a number (UTC date) but got " + reader.getTokenString());
                    }
                    long val = Long.parseLong(reader.getCopied());
                    reader.nextToken();
                    return new Date(val);
                }
            };
        }
        return null;
    }
}

