/*
 * Decompiled with CFR 0.152.
 */
package to.etc.json;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.json.ITypeMapping;
import to.etc.json.JsonTypeRegistry;
import to.etc.util.IndentWriter;
import to.etc.util.StringTool;

public class JsonWriter
extends Writer {
    @Nonnull
    private final Writer m_writer;
    @Nonnull
    private final JsonTypeRegistry m_registry;
    @Nullable
    private IndentWriter m_iw;

    public JsonWriter(@Nonnull Writer writer, @Nonnull JsonTypeRegistry registry) {
        this.m_writer = writer;
        this.m_registry = registry;
        if (writer instanceof IndentWriter) {
            this.m_iw = (IndentWriter)writer;
        }
    }

    @Override
    public void close() throws IOException {
        this.m_writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.m_writer.flush();
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.m_writer.write(cbuf, off, len);
    }

    public void writeNumber(@Nonnull Number value) throws Exception {
        this.m_writer.append(value.toString());
    }

    public void writeLong(long value) throws Exception {
        this.m_writer.append(Long.toString(value));
    }

    public void writeString(@Nullable String string) throws Exception {
        if (null == string) {
            this.write("null");
        } else {
            StringTool.strToJavascriptString(this.m_writer, string, false);
        }
    }

    public void render(@Nullable Object instance) throws Exception {
        this.render(instance, null);
    }

    public void render(@Nullable Object instance, @Nullable Type fullType) throws Exception {
        if (null == instance) {
            this.write("null");
            return;
        }
        ITypeMapping mapping = this.m_registry.createMapping(instance.getClass(), fullType);
        if (null == mapping) {
            throw new IllegalStateException("Could not find a json mapping for " + instance.getClass());
        }
        mapping.render(this, instance);
    }

    public void inc() {
        IndentWriter iw = this.m_iw;
        if (null == iw) {
            return;
        }
        iw.inc();
    }

    public void dec() throws IOException {
        IndentWriter iw = this.m_iw;
        if (null == iw) {
            return;
        }
        iw.dec();
    }

    public void nl() throws IOException {
        if (this.m_iw != null) {
            this.write("\n");
        }
    }
}

