/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import to.etc.util.TextScanner;

public class HtmlTextScanner
extends TextScanner {
    private List<String> m_tagStack = new ArrayList<String>();
    private static final Map<String, TagInfo> DEFAULT_MAP = new HashMap<String, TagInfo>();
    private Map<String, TagInfo> m_acceptMap = DEFAULT_MAP;
    private StringBuilder m_sb;
    private String m_lastSingleTag;

    private static void p(String node, boolean ends, boolean args) {
        DEFAULT_MAP.put(node, new TagInfo(ends, args));
    }

    private static void p(String node, boolean ends) {
        HtmlTextScanner.p(node, ends, false);
    }

    public Map<String, TagInfo> getMap() {
        return this.m_acceptMap;
    }

    public void scan(StringBuilder sb, String html) {
        this.setString(html);
        this.m_sb = sb;
        this.m_lastSingleTag = null;
        this.m_tagStack.clear();
        while (!this.eof()) {
            this.scanText(sb);
            if (this.eof()) break;
            this.scanTag();
        }
        while (this.m_tagStack.size() > 0) {
            sb.append("</");
            sb.append(this.m_tagStack.remove(this.m_tagStack.size() - 1));
            sb.append(">");
        }
    }

    public void scanAndRemove(StringBuilder sb, String html, boolean includelf) {
        this.setString(html);
        this.m_sb = sb;
        this.m_lastSingleTag = null;
        this.m_tagStack.clear();
        while (!this.eof()) {
            boolean ws = false;
            while (!this.eof()) {
                int c = this.LA();
                this.accept();
                if (Character.isWhitespace(c)) {
                    ws = true;
                    continue;
                }
                if (c == 60) break;
                if (ws) {
                    sb.append(' ');
                    ws = false;
                }
                sb.append((char)c);
            }
            if (this.eof()) break;
            if (includelf) {
                String name;
                boolean end = false;
                if (this.LA() == 47) {
                    end = true;
                    this.accept();
                }
                if ((name = this.scanWord()) != null) {
                    if (end) {
                        name = "/" + name;
                    }
                    if ("/p".equals(name) || "br".equals(name)) {
                        sb.append('\n');
                    }
                }
            }
            this.skipTag();
        }
    }

    private void scanTag() {
        String s;
        this.accept();
        this.skipWS();
        boolean endtag = false;
        if (this.LA() == 47) {
            endtag = true;
            this.accept();
            this.skipWS();
        }
        if ((s = this.scanWord()) == null) {
            this.skipTag();
            return;
        }
        s = s.toLowerCase();
        TagInfo ti = this.getMap().get(s);
        if (ti == null) {
            this.skipTag();
            return;
        }
        if (endtag) {
            if (s.equalsIgnoreCase(this.m_lastSingleTag)) {
                this.skipTag();
                this.m_lastSingleTag = null;
                return;
            }
            if (this.popStackIf(s)) {
                this.m_sb.append("</").append(s).append(">");
                this.skipTag();
                return;
            }
            this.skipTag();
            return;
        }
        this.skipTag();
        this.m_sb.append("<");
        this.m_sb.append(s);
        if (!ti.ends) {
            this.m_sb.append('>');
            this.m_tagStack.add(s);
            this.m_lastSingleTag = null;
            return;
        }
        this.m_sb.append("/>");
        this.m_lastSingleTag = s;
    }

    private boolean popStackIf(String s) {
        if (this.m_tagStack.size() == 0) {
            return false;
        }
        if (this.m_tagStack.get(this.m_tagStack.size() - 1).equalsIgnoreCase(s)) {
            this.m_tagStack.remove(this.m_tagStack.size() - 1);
            return true;
        }
        return false;
    }

    private void skipTag() {
        int sc = 0;
        while (!this.eof()) {
            int c = this.LA();
            this.accept();
            if (sc != 0) {
                if (sc != c) continue;
                sc = 0;
                continue;
            }
            if (c == 39 || c == 34) {
                sc = c;
                continue;
            }
            if (c != 62) continue;
            return;
        }
    }

    private void scanText(StringBuilder sb) {
        while (!this.eof()) {
            if (this.LA() == 60) {
                return;
            }
            this.copy(sb);
        }
    }

    public static void htmlRemoveUnsafe(StringBuilder outsb, String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        new HtmlTextScanner().scan(outsb, text);
    }

    public static String htmlRemoveUnsafe(String html) {
        if (html == null || html.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(html.length() + 20);
        HtmlTextScanner.htmlRemoveUnsafe(sb, html);
        return sb.toString();
    }

    public static void htmlRemoveAll(StringBuilder outsb, String text, boolean lf) {
        if (text == null || text.length() == 0) {
            return;
        }
        new HtmlTextScanner().scanAndRemove(outsb, text, lf);
    }

    public static String htmlRemoveAll(String html, boolean lf) {
        if (html == null || html.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(html.length() + 20);
        HtmlTextScanner.htmlRemoveAll(sb, html, lf);
        return sb.toString();
    }

    static {
        HtmlTextScanner.p("b", false);
        HtmlTextScanner.p("i", false);
        HtmlTextScanner.p("u", false);
        HtmlTextScanner.p("em", false);
        HtmlTextScanner.p("strong", false);
        HtmlTextScanner.p("ul", false);
        HtmlTextScanner.p("li", false);
        HtmlTextScanner.p("br", true);
    }

    private static class TagInfo {
        public boolean ends;

        public TagInfo(boolean ends, boolean args) {
            this.ends = ends;
        }
    }
}

