/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import java.io.IOException;
import java.io.Reader;
import to.etc.lexer.SourceErrorException;
import to.etc.lexer.SourceLocation;
import to.etc.lexer.TextReaderBase;

public class ReaderScannerBase
extends TextReaderBase {
    public static final int T_EOF = -1;
    public static final int T_STRING = -2;
    public static final int T_NUMBER = -3;
    public static final int T_IPADDR = -4;
    public static final int T_IDENT = -5;
    public static final int T_COMMENT = -6;
    public static final int T_BASE_LAST = -7;
    private int m_token_lnr;
    private int m_token_cnr;
    private boolean m_allowNewlineInString;

    public ReaderScannerBase(Object source, Reader r) {
        super(source, r);
    }

    public boolean isAllowNewlineInString() {
        return this.m_allowNewlineInString;
    }

    public void setAllowNewlineInString(boolean allowNewlineInString) {
        this.m_allowNewlineInString = allowNewlineInString;
    }

    public String tokenString(int type) {
        switch (type) {
            default: {
                return Character.toString((char)type);
            }
            case -1: {
                return "<<eof>>";
            }
            case -2: {
                return "string";
            }
            case -6: {
                return "comment";
            }
            case -5: {
                return "identifier";
            }
            case -4: {
                return "ip address";
            }
            case -3: 
        }
        return "number";
    }

    public int getTokenLine() {
        return this.m_token_lnr;
    }

    public int getTokenColumn() {
        return this.m_token_cnr;
    }

    public SourceLocation getSourceLocation() {
        return new SourceLocation(this);
    }

    public RuntimeException error(String msg) throws SourceErrorException {
        throw new SourceErrorException(this.getSourceLocation(), msg);
    }

    public void skipWs() throws IOException {
        int c;
        while ((c = this.LA()) != -1 && Character.isWhitespace((char)c)) {
            this.accept();
        }
        return;
    }

    public void skipWsNoNL() throws IOException {
        int c;
        while ((c = this.LA()) != -1 && c != 10 && Character.isWhitespace((char)c)) {
            this.accept();
        }
        return;
    }

    public void scanSimpleString(boolean keepquotes) throws IOException, SourceErrorException {
        int c;
        int qc = this.LA();
        this.accept();
        if (!keepquotes) {
            this.clearCopy();
        } else {
            this.append((char)qc);
        }
        while ((c = this.LA()) != qc) {
            if (c == -1) {
                this.error("Unexpected EOF in string constant started at line " + this.m_token_lnr + ":" + this.m_token_cnr);
            } else if (c == 10 && !this.isAllowNewlineInString()) {
                this.error("Unexpected newline in string constant started at line " + this.m_token_lnr + ":" + this.m_token_cnr + " (collected was " + this.getCopied() + ")");
            }
            this.append((char)c);
            this.accept();
        }
        if (keepquotes) {
            this.append(qc);
        }
        this.accept();
    }

    public int scanUndottedNumber() throws IOException {
        int c = this.LA();
        this.append(c);
        this.accept();
        int c2 = this.LA();
        int base = 10;
        if (c == 48) {
            if (c2 == 120 || c2 == 88) {
                base = 16;
                this.append(c2);
                this.accept();
            } else {
                base = 8;
            }
        }
        while ((c = this.LA()) != -1) {
            if (c >= 48 && c <= 57) {
                this.copy();
            } else if (base <= 10) break;
            if (base <= 10) continue;
            if ((c < 65 || c > 70) && (c < 97 || c > 102)) break;
            this.copy();
        }
        return -3;
    }

    public int scanNumber() throws IOException {
        int c = this.LA();
        this.append(c);
        this.accept();
        int c2 = this.LA();
        int base = 10;
        if (c == 48) {
            if (c2 == 120 || c2 == 88) {
                base = 16;
                this.append(c2);
                this.accept();
            } else {
                base = 8;
            }
        }
        int ndots = 0;
        while ((c = this.LA()) != -1) {
            if (c == 46) {
                if (this.LA(1) == 46) {
                    return -3;
                }
                ++ndots;
                this.accept();
                this.append(c);
                continue;
            }
            if (c >= 48 && c <= 57) {
                this.copy();
            } else if (base <= 10) break;
            if (base <= 10) continue;
            if ((c < 65 || c > 70) && (c < 97 || c > 102)) break;
            this.copy();
        }
        if (ndots <= 1) {
            return -3;
        }
        if (ndots == 3) {
            return -4;
        }
        throw new IllegalStateException("Odd number or IP address started at line " + this.m_token_lnr + ":" + this.m_token_cnr);
    }

    public int scanIdentifier() throws IOException {
        int c;
        while (this.isIdChar((char)(c = this.LA()))) {
            this.accept();
            this.append(c);
        }
        return -5;
    }

    public boolean isIdStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    public boolean isIdChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$';
    }

    public void startToken() {
        this.m_token_cnr = this.getCurrentColumn();
        this.m_token_lnr = this.getCurrentLine();
        this.clearCopy();
    }
}

