/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import java.io.IOException;
import java.io.Reader;
import to.etc.lexer.ReaderScannerBase;
import to.etc.lexer.SourceErrorException;

public class ReaderTokenizerBase
extends ReaderScannerBase {
    private boolean m_return_ws;
    private boolean m_return_nl;
    private boolean m_returnComment;
    private boolean m_keepQuotes;
    private boolean m_scanUndottedNumbers;
    private int m_lastToken = -1;

    public ReaderTokenizerBase(Object source, Reader r) {
        super(source, r);
    }

    public void setReturnWhitespace(boolean ws) {
        this.m_return_ws = ws;
    }

    public void setReturnNewline(boolean nl) {
        this.m_return_nl = nl;
    }

    public boolean isKeepQuotes() {
        return this.m_keepQuotes;
    }

    public void setKeepQuotes(boolean keepQuotes) {
        this.m_keepQuotes = keepQuotes;
    }

    public void setReturnComment(boolean returnComment) {
        this.m_returnComment = returnComment;
    }

    public String getTokenString() {
        int type = this.getLastToken();
        switch (type) {
            default: {
                return "'" + Character.toString((char)type) + "'";
            }
            case -1: {
                return "<<eof>>";
            }
            case -2: {
                return "string:" + this.getCopied();
            }
            case -6: {
                return "comment";
            }
            case -5: {
                return "identifier:" + this.getCopied();
            }
            case -4: {
                return "ip address:+" + this.getCopied();
            }
            case -3: 
        }
        return "number:" + this.getCopied();
    }

    protected int scanString() throws IOException, SourceErrorException {
        this.scanSimpleString(this.isKeepQuotes());
        return -2;
    }

    protected int scanToken() throws IOException {
        return -1;
    }

    public int getLastToken() {
        return this.m_lastToken;
    }

    public int nextToken() throws IOException, SourceErrorException {
        this.m_lastToken = this._nextToken();
        return this.m_lastToken;
    }

    /*
     * Unable to fully structure code
     */
    private int _nextToken() throws IOException, SourceErrorException {
        block7: while (true) lbl-1000:
        // 3 sources

        {
            block22: {
                if (!this.m_return_ws && !this.m_return_nl) {
                    this.skipWs();
                } else if (this.m_return_nl && !this.m_return_ws) {
                    this.skipWsNoNL();
                }
                this.startToken();
                c = this.LA();
                token = this.scanToken();
                if (token != -1) {
                    return token;
                }
                switch (c) {
                    default: {
                        if (Character.isWhitespace((char)c)) {
                            while ((!this.m_return_nl || c != 10) && c != -1 && Character.isWhitespace((char)c)) {
                                this.append((char)c);
                                this.accept();
                                c = this.LA();
                            }
                            return 32;
                        }
                        if (this.isIdStart((char)c)) {
                            return this.scanIdentifier();
                        }
                        this.append((char)c);
                        this.accept();
                        return c;
                    }
                    case 10: {
                        if (this.m_return_nl) {
                            this.append((char)c);
                            this.accept();
                            return c;
                        }
                        while (c != -1 && Character.isWhitespace((char)c)) {
                            this.append((char)c);
                            this.accept();
                            c = this.LA();
                        }
                        return 32;
                    }
                    case -1: {
                        return -1;
                    }
                    case 34: 
                    case 39: {
                        return this.scanString();
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (this.m_scanUndottedNumbers) {
                            return this.scanUndottedNumber();
                        }
                        return this.scanNumber();
                    }
                    case 47: 
                }
                if (this.LA(1) != 47) break block22;
                this.copy(2);
                while (true) {
                    block23: {
                        if ((c = this.LA()) != 10 && c != -1) break block23;
                        if (!this.m_returnComment) ** GOTO lbl-1000
                        return -6;
                    }
                    this.copy();
                }
            }
            if (this.LA(1) != 42) break;
            this.copy(2);
            lc = 0;
            while (true) {
                c = this.LA();
                this.copy();
                if (c == -1) {
                    throw new IllegalStateException("Unexpected EOF in multiline comment started at line " + this.getTokenLine() + ":" + this.getTokenColumn());
                }
                if (c == 47 && lc == 42) {
                    if (!this.m_returnComment) continue block7;
                    return -6;
                }
                lc = c;
            }
            break;
        }
        this.accept();
        this.append((char)c);
        return c;
    }

    public void setScanUndottedNumbers(boolean scanUndottedNumbers) {
        this.m_scanUndottedNumbers = scanUndottedNumbers;
    }
}

