/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import java.io.IOException;
import java.io.Reader;

public class TextReaderBase {
    private static final int MAX_QUEUE_LENGTH = 1024;
    private Object m_src;
    private Reader m_r;
    private boolean m_eof;
    private int m_lnr;
    private int m_cnr;
    private int[] m_la_ar = new int[1024];
    private int m_put_ix;
    private int m_get_ix;
    private int m_qlen;
    private StringBuilder m_collbuf;

    public TextReaderBase(Object source, Reader r) {
        this.m_r = r;
        this.m_src = source;
    }

    protected StringBuilder sb() {
        if (this.m_collbuf == null) {
            this.m_collbuf = new StringBuilder();
        }
        return this.m_collbuf;
    }

    public String getCopied() {
        if (this.m_collbuf == null) {
            return null;
        }
        return this.m_collbuf.toString();
    }

    public void clearCopy() {
        if (this.m_collbuf != null) {
            this.m_collbuf.setLength(0);
        }
    }

    protected void append(char c) {
        this.sb().append(c);
    }

    public void append(int c) {
        this.sb().append((char)c);
    }

    public Object getSource() {
        return this.m_src;
    }

    public int getCurrentLine() {
        return this.m_lnr;
    }

    public int getCurrentColumn() {
        return this.m_cnr;
    }

    private int getc() throws IOException {
        if (this.m_eof) {
            return -1;
        }
        int c = this.m_r.read();
        if (c == -1) {
            this.m_eof = true;
        }
        return c;
    }

    private void putq(int ch) {
        if (this.m_qlen >= 1024) {
            throw new IllegalStateException("Lookahead queue overflow");
        }
        if (this.m_put_ix >= 1024) {
            this.m_put_ix = 0;
        }
        this.m_la_ar[this.m_put_ix++] = ch;
        ++this.m_qlen;
    }

    public final int LA() throws IOException {
        if (this.m_qlen == 0) {
            this.putq(this.getc());
        }
        int c = this.m_la_ar[this.m_get_ix];
        return c;
    }

    public final int LA(int ix) throws IOException {
        while (ix >= this.m_qlen) {
            this.putq(this.getc());
        }
        if ((ix = this.m_get_ix + ix) >= 1024) {
            ix -= 1024;
        }
        return this.m_la_ar[ix];
    }

    public void accept() {
        if (this.m_qlen == 0) {
            throw new IllegalStateException("accept on empty lookahead queue");
        }
        int ch = this.m_la_ar[this.m_get_ix];
        if (ch == 10) {
            ++this.m_lnr;
            this.m_cnr = 0;
        } else if (ch != -1) {
            ++this.m_cnr;
        }
        --this.m_qlen;
        ++this.m_get_ix;
        if (this.m_get_ix >= 1024) {
            this.m_get_ix = 0;
        }
    }

    public void accept(int ct) {
        while (ct-- > 0) {
            this.accept();
        }
    }

    public void copy() throws IOException {
        int ch = this.LA();
        this.sb().append((char)ch);
        this.accept();
    }

    public void copy(int count) throws IOException {
        while (count-- > 0) {
            int ch = this.LA();
            this.sb().append((char)ch);
            this.accept();
        }
    }
}

