/*
 * Decompiled with CFR 0.152.
 */
package to.etc.lexer;

import java.io.Reader;
import to.etc.lexer.LexerToken;
import to.etc.lexer.ReaderScannerBase;

public abstract class TextTokenizerBase
extends ReaderScannerBase {
    private LexerToken[] m_tokenQueue = new LexerToken[32];
    private int m_qget;
    private int m_qput;
    private int m_qlen;

    protected abstract int nextTokenPrim() throws Exception;

    public TextTokenizerBase(Object source, Reader r) {
        super(source, r);
    }

    public void pushToken(LexerToken t) {
        if (t == null) {
            throw new IllegalArgumentException("token cannot be null");
        }
        if (this.m_qlen >= this.m_tokenQueue.length) {
            LexerToken[] ar = new LexerToken[this.m_tokenQueue.length * 2];
            System.arraycopy(this.m_tokenQueue, 0, ar, 0, this.m_tokenQueue.length);
            this.m_tokenQueue = ar;
        }
        if (this.m_qput >= this.m_tokenQueue.length) {
            this.m_qput = 0;
        }
        this.m_tokenQueue[this.m_qput++] = t;
        ++this.m_qlen;
    }

    public void pushTokenCopy(LexerToken t) {
        this.pushToken(t.dup());
    }

    public LexerToken popToken() {
        if (this.m_qlen <= 0) {
            return null;
        }
        if (this.m_qget >= this.m_tokenQueue.length) {
            this.m_qget = 0;
        }
        --this.m_qlen;
        return this.m_tokenQueue[this.m_qget++];
    }

    public int tokenStackSize() {
        return this.m_qlen;
    }

    public int nextToken(LexerToken t) throws Exception {
        if (this.tokenStackSize() > 0) {
            t.assignFrom(this.popToken());
            return t.getTokenCode();
        }
        this.startToken();
        int tc = this.nextTokenPrim();
        t.setTokenCode(tc);
        t.setColumn(this.getTokenColumn());
        t.setLine(this.getTokenLine());
        t.setSrc(this.getSource());
        t.setText(this.getCopied());
        return tc;
    }
}

