/*
 * Decompiled with CFR 0.152.
 */
package to.etc.pombuilder;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import to.etc.pombuilder.Project;
import to.etc.util.StringTool;
import to.etc.xml.XmlWriter;

public class PomBuilder {
    private static final String MAVENSHIT = ".maven";
    private static final String PARAM_VERSION = "-version=";
    private static final String PARAM_ROOT_POM_NAME = "-rootPomName=";
    private static final String PARAM_SKIP_ROOT_POM = "-skipRootPom";
    private static final String PARENT_DIRECTORY = "../";
    File m_rootPath;
    private String m_version = "trunk-SNAPSHOT";
    @Nonnull
    private static final Set<String> m_knownNameSet = new HashSet<String>();
    private static final String TOPNAME = "allViewpointModules";
    private Map<String, Project> m_prjMap = new HashMap<String, Project>();

    public static void main(String[] args) {
        try {
            new PomBuilder().run(args);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void run(String[] args) throws Exception {
        File prj = null;
        boolean skipRootPom = false;
        String rootPomName = "pom.xml";
        if (args.length >= 0) {
            for (String arg : args) {
                if (arg.startsWith(PARAM_VERSION)) {
                    this.m_version = arg.substring(PARAM_VERSION.length());
                    continue;
                }
                if (arg.startsWith(PARAM_SKIP_ROOT_POM)) {
                    skipRootPom = true;
                    continue;
                }
                if (arg.startsWith(PARAM_ROOT_POM_NAME)) {
                    rootPomName = arg.substring(PARAM_ROOT_POM_NAME.length());
                    System.out.println("...root pom name set to " + rootPomName);
                    continue;
                }
                if (prj != null) {
                    throw new IllegalStateException("prj is already defined! Invalid parameter encountered: " + arg);
                }
                prj = new File(arg);
            }
        }
        if (prj == null) {
            prj = this.findViewpointProjectPath(PARENT_DIRECTORY);
        }
        this.m_rootPath = prj.getParentFile();
        Project p = this.loadProject(prj);
        p.generateDependencies(new HashSet<Project>());
        System.out.println("Build order:");
        for (Project sub : p.getFullDepList()) {
            System.out.println(sub.getName());
        }
        for (Project sub : p.getFullDepList()) {
            System.out.println("... " + sub.getName());
            this.generateProjectPoms(sub);
        }
        this.generateProjectPoms(p);
        if (skipRootPom) {
            System.out.println("...skipping root pom.xml");
        } else {
            File f = new File(this.m_rootPath, rootPomName);
            XmlWriter w = this.createMavenXml(f, "nl.itris.viewpoint", TOPNAME, TOPNAME, "pom");
            w.tag("properties");
            w.tagfull("sonar.includedModules", this.getSonarModules(p));
            w.tagendnl();
            w.tag("modules");
            for (Project sub : p.getFullDepList()) {
                w.tagfull("module", sub.getRoot().getName());
            }
            w.tagfull("module", p.getRoot().getName());
            w.tagendnl();
            w.tagendnl();
            w.close();
        }
        System.out.println("done");
    }

    @Nonnull
    private String getSonarModules(@Nonnull Project prj) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Project> depset = new ArrayList<Project>(prj.getFullDepList());
        depset.add(prj);
        for (Project p : depset) {
            if (!p.hasSources()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(p.getProjectArtifactID());
            sb.append(",").append(p.getSourceArtefactId());
        }
        return sb.toString();
    }

    @Nonnull
    private String getSkippedSonarModules(@Nonnull Project prj) {
        StringBuilder sb = new StringBuilder();
        for (Project p : prj.getFullDepList()) {
            if (p.hasSources()) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(p.getProjectArtifactID());
        }
        return sb.toString();
    }

    @Nonnull
    private File findViewpointProjectPath(@Nonnull String rootPath) throws FileNotFoundException {
        File root = new File(rootPath);
        try {
            return this.findViewpointProjectPathInDirectory(root);
        }
        catch (FileNotFoundException ex) {
            File[] fileList;
            File rootParent = new File(PARENT_DIRECTORY + rootPath);
            for (File subdirectory : fileList = rootParent.listFiles()) {
                try {
                    return this.findViewpointProjectPathInDirectory(subdirectory);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
            throw new FileNotFoundException("Viewpoint project directory cannot be found.");
        }
    }

    @Nonnull
    private File findViewpointProjectPathInDirectory(@Nonnull File directory) throws FileNotFoundException {
        File[] fileList;
        if (directory.isDirectory() && (fileList = directory.listFiles()) != null && fileList.length > 0) {
            for (File viewpointDirectory : fileList) {
                if (!viewpointDirectory.isDirectory() || !"viewpoint".equals(viewpointDirectory.getName())) continue;
                return viewpointDirectory;
            }
        }
        throw new FileNotFoundException("Viewpoint project directory cannot be found in directory: " + directory.getName());
    }

    private void generateProjectPoms(Project sub) throws Exception {
        String srcmod;
        for (JarRef jr : sub.getJarList()) {
            this.generateJar(sub, jr);
        }
        File f = new File(sub.getRoot(), "pom.xml");
        XmlWriter w = this.createMavenXml(f, sub.getBaseGroup(), sub.getProjectArtifactID(), sub.getName(), "pom");
        w.tag("modules");
        for (JarRef jr : sub.getJarList()) {
            w.tagfull("module", jr.m_pomDir);
        }
        if (sub.hasSources() && (srcmod = this.generateSourceBuild(sub)) != null) {
            w.tagfull("module", srcmod);
        }
        w.tagendnl();
        w.tagendnl();
        w.close();
    }

    @Nonnull
    private String generateSourceBuild(Project sub) throws Exception {
        File mv = new File(sub.getRoot(), MAVENSHIT);
        mv.mkdirs();
        File f = new File(mv, "source");
        f.mkdirs();
        f = new File(f, "pom.xml");
        sub.m_groupId = sub.getBaseGroup();
        XmlWriter w = this.createMavenXml(f, sub.getBaseGroup(), sub.getSourceArtefactId(), sub.getName() + " source", "jar");
        w.tag("properties");
        w.tagfull("cobertura.maxmem", "8292M");
        w.tagfull("maven.cobertura.instrumentation.maxmemory", "8192M");
        w.tagfull("project.build.sourceEncoding", sub.getEncoding());
        w.tagfull("maven.compile.encoding", sub.getEncoding());
        w.tagfull("maven.compile.fork", "true");
        w.tagendnl();
        w.tag("build");
        ArrayList<String> sourceList = new ArrayList<String>();
        ArrayList<String> testList = new ArrayList<String>();
        if (sub.getSourceList().size() > 0) {
            String ms;
            for (String src : sub.getSourceList()) {
                if (PomBuilder.isTestSources(src)) {
                    testList.add(src);
                    continue;
                }
                sourceList.add(src);
            }
            if (sourceList.size() > 0) {
                ms = (String)sourceList.remove(0);
                w.tagfull("sourceDirectory", "../../" + ms);
            }
            if (testList.size() > 0) {
                ms = (String)testList.remove(0);
                w.tagfull("testSourceDirectory", "../../" + ms);
                if (testList.size() > 0) {
                    throw new RuntimeException(sub + ": too many 'test' source paths.");
                }
            }
            w.tag("resources");
            for (String src : sub.getSourceList()) {
                w.tag("resource");
                w.tagfull("directory", "../../" + src);
                w.tag("excludes");
                w.tagfull("exclude", "**/*.java");
                w.tagendnl();
                w.tagendnl();
            }
            w.tagendnl();
        }
        w.tag("plugins");
        w.tag("plugin");
        w.tagfull("groupId", "org.apache.maven.plugins");
        w.tagfull("artifactId", "maven-compiler-plugin");
        w.tagfull("version", "3.3");
        w.tag("configuration");
        w.tagfull("compilerId", "eclipse");
        w.tagfull("source", sub.getSourceVersion());
        w.tagfull("target", sub.getSourceVersion());
        w.tagfull("encoding", sub.getEncoding());
        w.tagendnl();
        w.tag("dependencies");
        w.tag("dependency");
        w.tagfull("groupId", "org.eclipse.tycho");
        w.tagfull("artifactId", "org.eclipse.jdt.core");
        w.tagfull("version", "3.11.0.v20150520-2033");
        w.tag("exclusions");
        w.tag("exclusion");
        w.tagfull("groupId", "org.eclipse.core");
        w.tagfull("artifactId", "resources");
        w.tagendnl();
        w.tag("exclusion");
        w.tagfull("groupId", "org.eclipse.core");
        w.tagfull("artifactId", "runtime");
        w.tagendnl();
        w.tag("exclusion");
        w.tagfull("groupId", "org.eclipse.core");
        w.tagfull("artifactId", "filesystem");
        w.tagendnl();
        w.tag("exclusion");
        w.tagfull("groupId", "org.eclipse.core");
        w.tagfull("artifactId", "text");
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tag("dependency");
        w.tagfull("groupId", "org.codehaus.plexus");
        w.tagfull("artifactId", "plexus-compiler-eclipse");
        w.tagfull("version", "2.5");
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tag("plugin");
        w.tagfull("groupId", "org.codehaus.mojo");
        w.tagfull("artifactId", "findbugs-maven-plugin");
        w.tagfull("version", "2.4.0");
        w.tag("configuration");
        w.tagfull("timeout", "60000000");
        w.tagendnl();
        w.tagendnl();
        if (sub.hasTests()) {
            w.tag("plugin");
            w.tagfull("groupId", "org.apache.maven.plugins");
            w.tagfull("artifactId", "maven-surefire-plugin");
            w.tagfull("version", "2.16");
            w.tag("configuration");
            w.tagfull("argLine", "-Xmx2048m -XX:-UseSplitVerifier");
            w.tagendnl();
            w.tag("dependencies");
            w.tag("dependency");
            w.tagfull("groupId", "org.apache.maven.surefire");
            w.tagfull("artifactId", "surefire-junit47");
            w.tagfull("version", "2.16");
            w.tagendnl();
            w.tagendnl();
            w.tagendnl();
            w.tag("plugin");
            w.tagfull("groupId", "org.apache.maven.plugins");
            w.tagfull("artifactId", "maven-jar-plugin");
            w.tagfull("version", "2.6");
            w.tag("executions");
            w.tag("execution");
            w.tag("goals");
            w.tagfull("goal", "test-jar");
            w.tagendnl();
            w.tagendnl();
            w.tagendnl();
            w.tagendnl();
        }
        this.generateExtraSourcesPukefest(w, sourceList);
        w.tagendnl();
        w.tagendnl();
        w.tag("dependencies");
        this.generateJarDeps(w, sub.getJarList());
        for (Project p : sub.getFullDepList()) {
            this.generateJarDeps(w, p.getJarList());
            if (!p.hasSources()) continue;
            w.tag("dependency");
            w.tagfull("groupId", p.m_groupId);
            w.tagfull("artifactId", p.getSourceArtefactId());
            w.tagfull("version", this.m_version);
            w.tagfull("type", "jar");
            w.tagfull("scope", "compile");
            w.tagendnl();
            if (!p.hasTests()) continue;
            w.tag("dependency");
            w.tagfull("groupId", p.m_groupId);
            w.tagfull("artifactId", p.getSourceArtefactId());
            w.tagfull("version", this.m_version);
            w.tagfull("type", "test-jar");
            w.tagfull("scope", "test");
            w.tagendnl();
        }
        w.tagendnl();
        w.tagendnl();
        w.close();
        return ".maven/source";
    }

    private void generateJarDeps(XmlWriter w, List<JarRef> list) throws Exception {
        for (JarRef jr : list) {
            w.tag("dependency");
            w.tagfull("groupId", jr.m_groupId);
            w.tagfull("artifactId", jr.m_artefactId);
            w.tagfull("version", this.m_version);
            w.tagfull("type", "jar");
            w.tagfull("scope", "compile");
            w.tagendnl();
        }
    }

    private void generateExtraSourcesPukefest(XmlWriter w, List<String> sourceList) throws Exception {
        if (sourceList.size() == 0) {
            return;
        }
        w.tag("plugin");
        w.tagfull("groupId", "org.codehaus.mojo");
        w.tagfull("artifactId", "build-helper-maven-plugin");
        w.tagfull("version", "1.7");
        w.tag("executions");
        w.tag("execution");
        w.tagfull("id", "add-source");
        w.tagfull("phase", "generate-sources");
        w.tag("goals");
        w.tagfull("goal", "add-source");
        w.tagendnl();
        w.tag("configuration");
        w.tag("sources");
        for (String src : sourceList) {
            w.tagfull("source", "../../" + src);
        }
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
    }

    private XmlWriter createMavenXml(File pom, String group, String art, String name, String pck) throws Exception {
        System.out.println("Generate " + pom);
        XmlWriter w = new XmlWriter(new OutputStreamWriter(new FileOutputStream(pom)));
        w.tag("project", "xmlns", "http://maven.apache.org/POM/4.0.0", "xmlns:xsl", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0");
        w.tagfull("modelVersion", "4.0.0");
        w.tagfull("groupId", group);
        w.tagfull("artifactId", art);
        w.tagfull("name", name);
        w.tagfull("version", this.m_version);
        w.tagfull("packaging", pck);
        return w;
    }

    private void generateJar(Project sub, JarRef jr) throws Exception {
        String basename = PomBuilder.removeVersionFromFile(jr.m_jar.getName());
        System.out.println("Jar: " + jr.m_jarName + ", basename=" + basename);
        File mroot = new File(sub.getRoot(), MAVENSHIT);
        jr.m_groupId = sub.getBaseGroup();
        jr.m_artefactId = sub.getBaseName() + "." + basename;
        File f = new File(mroot, basename);
        f.mkdirs();
        f = new File(f, "pom.xml");
        jr.m_pomDir = ".maven/" + basename;
        System.out.println("Generate " + f);
        XmlWriter w = new XmlWriter(new OutputStreamWriter(new FileOutputStream(f)));
        w.tag("project", "xmlns", "http://maven.apache.org/POM/4.0.0", "xmlns:xsl", "http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://maven.apache.org/POM/4.0.0");
        w.tagfull("modelVersion", "4.0.0");
        w.tagfull("groupId", jr.m_groupId);
        w.tagfull("artifactId", jr.m_artefactId);
        w.tagfull("name", jr.m_jarName);
        w.tagfull("version", this.m_version);
        w.tagfull("packaging", "jar");
        w.tag("build");
        w.tag("plugins");
        w.tag("plugin");
        w.tagfull("artifactId", "maven-antrun-plugin");
        w.tag("executions");
        w.tag("execution");
        w.tagfull("id", "Do the immensely complex task of copying a single file to the repository in only 29 lines of xml. Welcome to the joys of Maven.");
        w.tagfull("phase", "verify");
        w.tag("goals");
        w.tagfull("goal", "run");
        w.tagendnl();
        w.tag("configuration");
        w.tag("tasks");
        w.tag("copy", "overwrite", "true", "file", "../../" + jr.m_jarName, "tofile", "${project.build.directory}/${project.artifactId}-${project.version}.jar");
        w.wraw("\n");
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.tagendnl();
        w.close();
    }

    @Nonnull
    public Project loadProject(@Nonnull File dir) throws Exception {
        String name = dir.getName().toLowerCase();
        Project p = this.m_prjMap.get(name);
        if (null != p) {
            return p;
        }
        p = Project.createProject(this, dir);
        this.m_prjMap.put(name, p);
        return p;
    }

    @Nonnull
    public static String generateUniqueName(@Nonnull String bn) {
        int cn = 1;
        String name = bn;
        while (m_knownNameSet.contains(name)) {
            name = bn + cn++;
        }
        m_knownNameSet.add(name);
        return name;
    }

    @Nonnull
    public static String removeVersionFromDir(@Nonnull String in) {
        String[] ar = in.split("-");
        if (ar == null) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ar.length; ++i) {
            if (PomBuilder.isDottedVersion(ar[i])) continue;
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(ar[i]);
        }
        return sb.toString();
    }

    @Nonnull
    private static String removeVersionFromFile(@Nonnull String in) {
        String ext;
        int d = in.lastIndexOf(46);
        if (d != -1) {
            ext = in.substring(d + 1);
            if (!StringTool.isNumber(ext)) {
                in = in.substring(0, d);
                ext = in.substring(d);
            } else {
                ext = "";
            }
        } else {
            ext = "";
        }
        String[] ar = in.split("-");
        if (ar == null) {
            return in;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ar.length; ++i) {
            if (PomBuilder.isDottedVersion(ar[i])) continue;
            if (sb.length() != 0) {
                sb.append('-');
            }
            sb.append(ar[i]);
        }
        sb.append(ext);
        return sb.toString();
    }

    private static boolean isDottedVersion(@Nonnull String string) {
        String[] dots = (string = string.replace("rc", ".")).split("\\.");
        if (dots == null) {
            dots = new String[]{string};
        }
        for (String s : dots) {
            if (StringTool.isNumber(s)) continue;
            return false;
        }
        return true;
    }

    public static boolean isTestSources(@Nonnull String src) {
        return src.endsWith("test") || src.endsWith("test/");
    }

    static class JarRef {
        String m_jarName;
        File m_jar;
        String m_groupId;
        String m_artefactId;
        String m_pomDir;

        JarRef() {
        }
    }
}

