/*
 * Decompiled with CFR 0.152.
 */
package to.etc.pombuilder;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import to.etc.pombuilder.PomBuilder;
import to.etc.util.FileTool;
import to.etc.xml.DOMDecoder;
import to.etc.xml.DomTools;

class Project {
    @Nonnull
    private final PomBuilder m_builder;
    @Nonnull
    private final File m_root;
    @Nonnull
    private final String m_baseName;
    @Nonnull
    private final String m_baseGroup;
    @Nonnull
    private final String m_name;
    @Nonnull
    private final String m_encoding;
    private boolean m_hasSources;
    boolean m_dependenciesDone;
    String m_groupId;
    private final String m_sourceArtefactId;
    @Nonnull
    private String m_sourceVersion = "1.6";
    @Nonnull
    private String m_targetVersion = "1.6";
    private final List<String> m_sourceList = new ArrayList<String>();
    private final List<Project> m_directDepList = new ArrayList<Project>();
    private final List<PomBuilder.JarRef> m_jarList = new ArrayList<PomBuilder.JarRef>();
    private final List<Project> m_fullDepList = new ArrayList<Project>();
    private boolean m_hasTests;

    private Project(@Nonnull PomBuilder b, @Nonnull String name, @Nonnull File root, @Nonnull String baseGroup, @Nonnull String baseName, @Nonnull String encoding) {
        this.m_builder = b;
        this.m_root = root;
        this.m_name = name;
        this.m_baseName = baseName;
        this.m_baseGroup = baseGroup;
        this.m_encoding = encoding;
        this.m_sourceArtefactId = this.getBaseName() + ".source";
    }

    public static Project createProject(@Nonnull PomBuilder b, @Nonnull File dir) throws Exception {
        String name = dir.getName().toLowerCase();
        File classfile = new File(dir, ".classpath");
        File prjfile = new File(dir, ".project");
        if (!(classfile.isFile() && classfile.exists() && prjfile.isFile() && prjfile.exists())) {
            throw new IllegalArgumentException(dir + " is not an eclipse project directory.");
        }
        String base = name;
        String baseGroup = "nl.itris";
        if (base.startsWith("bin-") || base.startsWith("lib-")) {
            base = base.substring(4);
            baseGroup = "nl.itris.external";
        } else if (base.startsWith("to.")) {
            baseGroup = "to.etc";
        }
        String basename = PomBuilder.removeVersionFromDir(base);
        basename = PomBuilder.generateUniqueName(basename);
        String encoding = Project.loadEncoding(dir);
        Project p = new Project(b, name, dir, baseGroup, basename, encoding);
        p.loadClassFile(classfile);
        p.loadJavaPreferences();
        p.checkSources();
        return p;
    }

    private void checkSources() throws Exception {
        for (String srcref : this.m_sourceList) {
            File path = new File(this.m_root, srcref);
            if (!path.exists() || !path.isDirectory()) continue;
            if (PomBuilder.isTestSources(srcref)) {
                this.m_hasTests = true;
                continue;
            }
            int nf = this.countFiles(path, 3);
            if (nf < 3) continue;
            this.m_hasSources = true;
        }
    }

    private int countFiles(@Nonnull File root, int max) {
        File f;
        File[] ar = root.listFiles();
        int count = 0;
        int i = ar.length;
        while (--i >= 0) {
            f = ar[i];
            if (f.isFile()) {
                ++count;
            }
            if (count < max) continue;
            return count;
        }
        i = ar.length;
        while (--i >= 0) {
            int tc;
            f = ar[i];
            if (!f.isDirectory() || (count += (tc = this.countFiles(f, max - count))) < max) continue;
            return count;
        }
        return count;
    }

    private void loadJavaPreferences() throws Exception {
        File enc = new File(this.getRoot(), ".settings/org.eclipse.jdt.core.prefs");
        if (enc.exists()) {
            Properties pf = FileTool.loadProperties(enc);
            String s = pf.getProperty("org.eclipse.jdt.core.compiler.compliance");
            if (s != null) {
                this.setSourceVersion(s);
            }
            if ((s = pf.getProperty("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) != null) {
                this.setTargetVersion(s);
            }
        }
    }

    @Nonnull
    private static String loadEncoding(@Nonnull File dir) throws Exception {
        File enc = new File(dir, ".settings/org.eclipse.core.resources.prefs");
        String encoding = null;
        if (enc.exists()) {
            Properties encp = FileTool.loadProperties(enc);
            encoding = encp.getProperty("encoding/<project>");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    private void loadClassFile(@Nonnull File classfile) throws Exception {
        Document doc = DomTools.getDocument(classfile, false);
        Node root = DomTools.getRootElement(doc);
        DOMDecoder d = new DOMDecoder(root);
        for (DOMDecoder child : d.getChildIterator()) {
            String path;
            if (!child.getCurrentRoot().getNodeName().equals("classpathentry")) continue;
            Node n = child.getCurrentRoot();
            String kind = DomTools.strAttr(n, "kind");
            if ("src".equals(kind)) {
                path = DomTools.strAttr(n, "path");
                if (path.startsWith("/")) {
                    File f = new File(this.m_builder.m_rootPath, path.substring(1));
                    Project dp = this.m_builder.loadProject(f);
                    this.getDirectDepList().add(dp);
                    continue;
                }
                this.getSourceList().add(path);
                continue;
            }
            if (!"lib".equals(kind)) continue;
            path = DomTools.strAttr(n, "path");
            if (path.startsWith("/")) {
                throw new IllegalStateException("Link to external jar not allowed in " + this.getName() + ": " + path);
            }
            File jar = new File(this.getRoot(), path);
            if (!jar.exists() || !jar.isFile()) {
                System.out.println("Ignoring nonexistent " + jar);
                continue;
            }
            PomBuilder.JarRef j = new PomBuilder.JarRef();
            j.m_jar = new File(this.getRoot(), path);
            j.m_jarName = path;
            this.getJarList().add(j);
        }
    }

    public void generateDependencies(@Nonnull HashSet<Project> stack) {
        if (this.m_dependenciesDone) {
            return;
        }
        if (stack.contains(this)) {
            throw new IllegalStateException("Circular dependency on " + this.getName());
        }
        stack.add(this);
        for (Project sub : this.getDirectDepList()) {
            sub.generateDependencies(stack);
            Project.addNewTo(this.getFullDepList(), sub.getFullDepList());
            if (this.getFullDepList().contains(sub)) continue;
            this.getFullDepList().add(sub);
        }
        stack.remove(this);
        this.m_dependenciesDone = true;
    }

    private static void addNewTo(@Nonnull List<Project> target, @Nonnull List<Project> src) {
        for (Project p : src) {
            if (target.contains(p)) continue;
            target.add(p);
        }
    }

    @Nonnull
    public File getRoot() {
        return this.m_root;
    }

    @Nonnull
    public String getBaseName() {
        return this.m_baseName;
    }

    @Nonnull
    public String getBaseGroup() {
        return this.m_baseGroup;
    }

    @Nonnull
    public String getName() {
        return this.m_name;
    }

    @Nonnull
    public String getEncoding() {
        return this.m_encoding;
    }

    @Nonnull
    public String getSourceVersion() {
        return this.m_sourceVersion;
    }

    public void setSourceVersion(@Nonnull String sourceVersion) {
        this.m_sourceVersion = sourceVersion;
    }

    @Nonnull
    public String getTargetVersion() {
        return this.m_targetVersion;
    }

    public void setTargetVersion(@Nonnull String targetVersion) {
        this.m_targetVersion = targetVersion;
    }

    @Nonnull
    public List<String> getSourceList() {
        return this.m_sourceList;
    }

    @Nonnull
    public List<Project> getDirectDepList() {
        return this.m_directDepList;
    }

    @Nonnull
    public List<PomBuilder.JarRef> getJarList() {
        return this.m_jarList;
    }

    @Nonnull
    public List<Project> getFullDepList() {
        return this.m_fullDepList;
    }

    @Nonnull
    public String getSourceArtefactId() {
        if (!this.hasSources()) {
            throw new IllegalStateException("There should not be an artifact ID for a module without sources (module " + this.getName() + ")");
        }
        return this.m_sourceArtefactId;
    }

    public boolean hasSources() {
        return this.m_hasSources;
    }

    @Nonnull
    public String getProjectArtifactID() {
        return this.getBaseName() + ".BasePOM";
    }

    public boolean hasTests() {
        return this.m_hasTests;
    }
}

