/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class BColorQuantizer {
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static int[] SQUARES;
    static int[] SHIFT;

    public static BufferedImage quantizeImage(BufferedImage srcbi, int max_colors, boolean quick) {
        int w = srcbi.getWidth();
        int h = srcbi.getHeight();
        WritableRaster wr = Raster.createInterleavedRaster(0, w, h, w, 1, new int[]{0}, new Point(0, 0));
        DataBuffer db = wr.getDataBuffer();
        Cube cube = new Cube(db, srcbi, max_colors);
        cube.setQuick(quick);
        cube.classification();
        cube.reduction();
        cube.assignment();
        IndexColorModel cm = new IndexColorModel(8, cube.colormap.length, cube.colormap, 0, false, -1, 0);
        BufferedImage bi = new BufferedImage(cm, wr, false, null);
        return bi;
    }

    public static void main(String[] args) {
        BufferedImage bi = new BufferedImage(20, 40, 13);
        System.out.println("Raster is " + bi.getSampleModel().getClass().getName());
        PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)bi.getSampleModel();
        System.out.println("sm: bands=" + sm.getNumBands() + ", pxstride=" + sm.getPixelStride() + ", scanstride=" + sm.getScanlineStride() + ", data=" + sm.getDataType());
    }

    static {
        int i;
        SQUARES = new int[511];
        for (i = -255; i <= 255; ++i) {
            BColorQuantizer.SQUARES[i + 255] = i * i;
        }
        SHIFT = new int[9];
        for (i = 0; i < 9; ++i) {
            BColorQuantizer.SHIFT[i] = 1 << 15 - i;
        }
    }

    static class Cube {
        private boolean m_quick = true;
        private BufferedImage m_bi;
        private int m_w;
        private DataBuffer m_db;
        int max_colors;
        int[] colormap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(DataBuffer db, BufferedImage bi, int max_colors) {
            this.m_bi = bi;
            this.max_colors = max_colors;
            this.m_db = db;
            this.m_w = bi.getWidth();
            int i = max_colors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        public void setQuick(boolean on) {
            this.m_quick = on;
        }

        void classification() {
            int width = this.m_bi.getWidth();
            int height = this.m_bi.getHeight();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = this.m_bi.getRGB(x, y);
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (this.nodes > 266817) {
                        System.out.println("pruning");
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    for (int level = 1; level <= this.depth; ++level) {
                        int id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2;
                        if (node.m_child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.m_child[id];
                        node.number_pixels += SHIFT[level];
                    }
                    ++node.unique;
                    node.total_red += red;
                    node.total_green += green;
                    node.total_blue += blue;
                }
            }
        }

        void reduction() {
            int threshold = 1;
            while (this.colors > this.max_colors) {
                this.colors = 0;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new int[this.colors];
            this.colors = 0;
            this.root.colormap();
            int width = this.m_bi.getWidth();
            int height = this.m_bi.getHeight();
            Search search = new Search();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int id;
                    int pixel = this.m_bi.getRGB(x, y);
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    Node node = this.root;
                    while (node.m_child[id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2] != null) {
                        node = node.m_child[id];
                    }
                    if (this.m_quick) {
                        this.m_db.setElem(x + this.m_w * y, node.color_number);
                        System.out.println("(" + x + "," + y + ": " + Integer.toString(node.color_number));
                        continue;
                    }
                    search.distance = Integer.MAX_VALUE;
                    node.m_parent.closestColor(red, green, blue, search);
                    this.m_db.setElem(x + this.m_w * y, search.color_number);
                }
            }
        }

        static class Node {
            Cube m_cube;
            Node m_parent;
            Node[] m_child;
            int m_nchild;
            int m_id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube) {
                this.m_cube = cube;
                this.m_parent = this;
                this.m_child = new Node[8];
                this.m_id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = 128;
                this.mid_green = 128;
                this.mid_blue = 128;
            }

            Node(Node parent, int id, int level) {
                this.m_cube = parent.m_cube;
                this.m_parent = parent;
                this.m_child = new Node[8];
                this.m_id = id;
                this.level = level;
                ++this.m_cube.nodes;
                if (level == this.m_cube.depth) {
                    ++this.m_cube.colors;
                }
                ++parent.m_nchild;
                parent.m_child[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.mid_red = parent.mid_red + ((id & 1) > 0 ? bi : -bi);
                this.mid_green = parent.mid_green + ((id & 2) > 0 ? bi : -bi);
                this.mid_blue = parent.mid_blue + ((id & 4) > 0 ? bi : -bi);
            }

            void pruneChild() {
                --this.m_parent.m_nchild;
                this.m_parent.unique += this.unique;
                this.m_parent.total_red += this.total_red;
                this.m_parent.total_green += this.total_green;
                this.m_parent.total_blue += this.total_blue;
                this.m_parent.m_child[this.m_id] = null;
                --this.m_cube.nodes;
                this.m_cube = null;
                this.m_parent = null;
            }

            void pruneLevel() {
                if (this.m_nchild != 0) {
                    for (int i = 0; i < 8; ++i) {
                        if (this.m_child[i] == null) continue;
                        this.m_child[i].pruneLevel();
                    }
                }
                if (this.level == this.m_cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int threshold, int next_threshold) {
                if (this.m_nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.m_child[id] == null) continue;
                        next_threshold = this.m_child[id].reduce(threshold, next_threshold);
                    }
                }
                if (this.number_pixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.m_cube.colors;
                    }
                    if (this.number_pixels < next_threshold) {
                        next_threshold = this.number_pixels;
                    }
                }
                return next_threshold;
            }

            void colormap() {
                if (this.m_nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.m_child[id] == null) continue;
                        this.m_child[id].colormap();
                    }
                }
                if (this.unique != 0) {
                    int r = (this.total_red + (this.unique >> 1)) / this.unique;
                    int g = (this.total_green + (this.unique >> 1)) / this.unique;
                    int b = (this.total_blue + (this.unique >> 1)) / this.unique;
                    this.m_cube.colormap[this.m_cube.colors] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                    this.color_number = this.m_cube.colors++;
                }
            }

            void closestColor(int red, int green, int blue, Search search) {
                int color;
                int distance;
                if (this.m_nchild != 0) {
                    for (int id = 0; id < 8; ++id) {
                        if (this.m_child[id] == null) continue;
                        this.m_child[id].closestColor(red, green, blue, search);
                    }
                }
                if (this.unique != 0 && (distance = Node.distance(color = this.m_cube.colormap[this.color_number], red, green, blue)) < search.distance) {
                    search.distance = distance;
                    search.color_number = this.color_number;
                }
            }

            static final int distance(int color, int r, int g, int b) {
                return SQUARES[(color >> 16 & 0xFF) - r + 255] + SQUARES[(color >> 8 & 0xFF) - g + 255] + SQUARES[(color >> 0 & 0xFF) - b + 255];
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                if (this.m_parent == this) {
                    buf.append("root");
                } else {
                    buf.append("node");
                }
                buf.append(' ');
                buf.append(this.level);
                buf.append(" [");
                buf.append(this.mid_red);
                buf.append(',');
                buf.append(this.mid_green);
                buf.append(',');
                buf.append(this.mid_blue);
                buf.append(']');
                return new String(buf);
            }
        }

        static class Search {
            int distance;
            int color_number;

            Search() {
            }
        }
    }
}

