/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.image.BufferedImage;
import java.io.IOException;
import to.etc.sjit.AnimGifDecoder;
import to.etc.sjit.GifImaMeta;

public abstract class GifHandlerBase {
    protected AnimGifDecoder m_gd;
    protected GifImaMeta m_im;
    protected int m_type;
    protected BufferedImage m_bi;
    protected int m_interlace_phase;
    protected int m_out_o;
    protected int m_x;
    protected int m_y;
    protected int m_out_e;
    protected int m_w;
    protected int m_h;
    private static int[] inter_data = new int[]{0, 1, 0, 8, 4, 8, 2, 4, 1, 2};

    public GifHandlerBase(AnimGifDecoder gd, GifImaMeta im, int type) {
        this.m_gd = gd;
        this.m_im = im;
        this.m_type = type;
        this.m_w = this.m_im.m_w;
        this.m_h = this.m_im.m_h;
        this.m_out_o = 0;
        this.m_x = 0;
        this.m_y = 0;
        if (this.m_im.m_interlaced) {
            this.m_interlace_phase = 2;
            this.m_out_e = this.m_w;
        } else {
            this.m_interlace_phase = 0;
            this.m_out_e = this.m_w * this.m_h;
        }
    }

    protected int getRunMax() {
        return this.m_out_e - this.m_out_o;
    }

    protected void incrementPos(int nwritten) {
        this.m_out_o += nwritten;
        this.m_x += nwritten;
        if (this.m_out_o < this.m_out_e) {
            return;
        }
        if (this.m_interlace_phase == 0) {
            return;
        }
        this.m_y += inter_data[this.m_interlace_phase + 1];
        if (this.m_y >= this.m_h) {
            this.m_interlace_phase += 2;
            if (this.m_interlace_phase >= inter_data.length) {
                return;
            }
            this.m_y = inter_data[this.m_interlace_phase];
        }
        this.m_out_o = this.m_y * this.m_w;
        this.m_out_e = this.m_out_o + this.m_w;
        this.m_x = 0;
    }

    protected int getOffset() {
        return this.m_out_o;
    }

    protected int getX() {
        return this.m_x;
    }

    protected int getY() {
        return this.m_y;
    }

    protected abstract BufferedImage prepare() throws IOException;

    protected abstract void pixels(byte[] var1, int var2) throws IOException;
}

