/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import to.etc.sjit.AnimGifDecoder;
import to.etc.sjit.GifHandlerBase;
import to.etc.sjit.GifImaMeta;

public class GifIndexedHandler
extends GifHandlerBase {
    private IndexColorModel m_icm;
    private DataBufferByte m_dbb;
    private byte[] m_data;

    public GifIndexedHandler(AnimGifDecoder de, GifImaMeta im, int type) {
        super(de, im, type);
    }

    @Override
    protected BufferedImage prepare() throws IOException {
        this.m_icm = this.m_im.m_transparant ? new IndexColorModel(this.m_im.m_bits_colortable, this.m_im.m_sz_colortable, this.m_im.m_reds, this.m_im.m_grns, this.m_im.m_blus, this.m_im.m_transparant_ix) : new IndexColorModel(this.m_im.m_bits_colortable, this.m_im.m_sz_colortable, this.m_im.m_reds, this.m_im.m_grns, this.m_im.m_blus);
        this.m_bi = new BufferedImage(this.m_im.m_w, this.m_im.m_h, this.m_type, this.m_icm);
        WritableRaster ras = this.m_bi.getRaster();
        SampleModel tsm = ras.getSampleModel();
        if (!(tsm instanceof PixelInterleavedSampleModel)) {
            return null;
        }
        DataBuffer dbt = ras.getDataBuffer();
        if (dbt.getDataType() != 0) {
            return null;
        }
        if (dbt.getNumBanks() != 1) {
            return null;
        }
        this.m_dbb = (DataBufferByte)dbt;
        this.m_data = this.m_dbb.getData();
        return this.m_bi;
    }

    @Override
    protected void pixels(byte[] pix, int len) throws IOException {
        int poff = 0;
        while (len > 0) {
            int m = this.getRunMax();
            if (m > len) {
                m = len;
            }
            int off = this.getOffset();
            System.arraycopy(pix, poff, this.m_data, off, m);
            len -= m;
            this.incrementPos(m);
            poff += m;
        }
    }
}

