/*
 * Decompiled with CFR 0.152.
 */
package to.etc.sjit;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import to.etc.sjit.AnimGifDecoder;
import to.etc.sjit.AnimGifEncoder;
import to.etc.sjit.ImageSubsampler;
import to.etc.sjit.Lanczos3Filter;
import to.etc.sjit.ResamplerFilter;
import to.etc.util.FileTool;
import to.etc.util.NullOutputStream;

public class ImaTool {
    private static Frame m_frame;

    private ImaTool() {
    }

    public static Dimension resizeWithAspect(int dw, int dh, int sw, int sh) {
        double fx = (double)sw / (double)dw;
        double fy = (double)sh / (double)dh;
        double f = fx / fy;
        if (f >= 1.0) {
            dh = (int)((double)sh / fx + 0.5);
        } else {
            dw = (int)((double)sw / fy + 0.5);
        }
        return new Dimension(dw, dh);
    }

    public static Dimension resizeWithAspect(Dimension dest, Dimension src) {
        double fx = (double)src.width / (double)dest.width;
        double fy = (double)src.height / (double)dest.height;
        double f = fx / fy;
        if (f >= 1.0) {
            return new Dimension(dest.width, (int)((double)src.height / fx + 0.5));
        }
        return new Dimension((int)((double)src.width / fy + 0.5), dest.height);
    }

    public static BufferedImage makeBuffered(Image i, int bit) {
        if (i instanceof BufferedImage) {
            return (BufferedImage)i;
        }
        int iw = i.getWidth(null);
        int ih = i.getHeight(null);
        BufferedImage bi = new BufferedImage(iw, ih, bit);
        Graphics g = bi.getGraphics();
        g.drawImage(i, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static BufferedImage makeBuffered(Image i) {
        return ImaTool.makeBuffered(i, 1);
    }

    public static BufferedImage loadPNG(InputStream is) throws IOException {
        return ImageIO.read(is);
    }

    public static BufferedImage loadJPEG(InputStream is) throws IOException {
        return ImageIO.read(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadJPEG(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        try {
            BufferedImage bufferedImage = ImaTool.loadJPEG(fis);
            return bufferedImage;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void saveJPEG(BufferedImage bi, OutputStream os, double qf) throws IOException {
        ImageIO.write((RenderedImage)bi, "JPG", os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveJPEG(BufferedImage bi, File f, double qf) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            ImaTool.saveJPEG(bi, fos, qf);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage loadGIF(File f, int buffertype) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            BufferedImage bufferedImage = ImaTool.loadGIF(is, buffertype);
            return bufferedImage;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (Exception exception) {}
        }
    }

    public static BufferedImage loadGIF(InputStream is, int buffertype) throws IOException {
        AnimGifDecoder ade = new AnimGifDecoder(is);
        BufferedImage bi = ade.read(buffertype);
        return bi;
    }

    public static BufferedImage loadGIF(InputStream is) throws IOException {
        return ImaTool.loadGIF(is, 13);
    }

    public static BufferedImage loadGIF(File f) throws IOException {
        return ImaTool.loadGIF(f, 13);
    }

    public static void saveGIF(BufferedImage bi, OutputStream os) throws Exception {
        AnimGifEncoder age = new AnimGifEncoder(os);
        age.add(bi);
        age.encode();
        age.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGIF(BufferedImage bi, File f) throws Exception {
        FileOutputStream fos = new FileOutputStream(f);
        try {
            ImaTool.saveGIF(bi, fos);
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void savePNG(BufferedImage bi, File f) throws Exception {
        ImageIO.write((RenderedImage)bi, "PNG", f);
    }

    public static void savePNG(BufferedImage bi, OutputStream f) throws Exception {
        ImageIO.write((RenderedImage)bi, "PNG", f);
    }

    public static BufferedImage loadFile(File f) throws IOException {
        String ext = FileTool.getFileExtension(f.toString());
        if (ext.length() < 3) {
            return null;
        }
        try {
            if (ext.equalsIgnoreCase("gif")) {
                return ImaTool.loadGIF(f);
            }
            if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")) {
                return ImaTool.loadJPEG(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return ImaTool.loadJPEG(f);
        }
        catch (Exception exception) {
            try {
                return ImaTool.loadGIF(f);
            }
            catch (Exception exception2) {
                return ImaTool.awtLoadBufferedImage(f);
            }
        }
    }

    public static Image loadFile_image(File f) throws IOException {
        String ext = FileTool.getFileExtension(f.toString());
        if (ext.length() < 3) {
            return null;
        }
        try {
            if (ext.equalsIgnoreCase("gif")) {
                return ImaTool.loadGIF(f);
            }
            if (ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg")) {
                return ImaTool.loadJPEG(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return ImaTool.loadJPEG(f);
        }
        catch (Exception exception) {
            try {
                return ImaTool.loadGIF(f);
            }
            catch (Exception exception2) {
                return ImaTool.awtLoadImage(f);
            }
        }
    }

    public static BufferedImage loadStream(InputStream is, String type) throws IOException {
        if ((type = type.toLowerCase()).indexOf("jpeg") != -1 || type.indexOf("jpg") != -1) {
            return ImaTool.loadJPEG(is);
        }
        if (type.indexOf("gif") != -1) {
            return ImaTool.loadGIF(is);
        }
        if (type.indexOf("png") != -1) {
            return ImaTool.loadPNG(is);
        }
        return null;
    }

    private static Frame getFrame() {
        if (m_frame == null) {
            m_frame = new Frame();
        }
        return m_frame;
    }

    public static Image awtLoadImage(File f) throws IOException {
        try {
            MediaTracker mt = new MediaTracker(ImaTool.getFrame());
            Image ima = Toolkit.getDefaultToolkit().createImage(f.toString());
            mt.addImage(ima, 0);
            mt.waitForAll();
            Image r = ima;
            if (mt.isErrorAny()) {
                r = null;
            }
            mt.removeImage(ima, 0);
            return r;
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted load");
        }
    }

    public static BufferedImage awtLoadBufferedImage(File f) throws IOException {
        return ImaTool.makeBuffered(ImaTool.awtLoadImage(f));
    }

    public static BufferedImage resizeFiltered_RAW(BufferedImage bi, int w, int h, ResamplerFilter fil) {
        BufferedImage obi = ImageSubsampler.resample(bi, fil, w, h);
        return obi;
    }

    public static BufferedImage resizeFiltered_RAW(BufferedImage i, int w, int h) {
        return ImaTool.resizeFiltered(i, w, h, new Lanczos3Filter());
    }

    public static BufferedImage resizeFiltered(BufferedImage bi, int w, int h, ResamplerFilter fil) {
        int iw = bi.getWidth();
        int ih = bi.getHeight();
        Dimension p = ImaTool.resizeWithAspect(w, h, iw, ih);
        BufferedImage obi = ImageSubsampler.resample(bi, fil, p.width, p.height);
        return obi;
    }

    public static BufferedImage resizeFiltered(BufferedImage i, int w, int h) {
        return ImaTool.resizeFiltered(i, w, h, new Lanczos3Filter());
    }

    public static BufferedImage awtResize(BufferedImage bi, int w, int h) {
        int iw = bi.getWidth();
        int ih = bi.getHeight();
        Dimension p = ImaTool.resizeWithAspect(w, h, iw, ih);
        BufferedImage obi = new BufferedImage(p.width, p.height, bi.getType());
        Graphics2D g = (Graphics2D)obi.getGraphics();
        g.drawImage((Image)bi, 0, 0, null);
        g.dispose();
        return obi;
    }

    public static double findQualityBySize(BufferedImage bi, int sizenear) {
        double lowq = 0.2;
        double hiq = 1.0;
        double q = 1.0;
        int iter = 0;
        int aiter = 0;
        int esz = sizenear + sizenear / 10;
        int bsz = sizenear - sizenear / 10;
        int sz = 0;
        NullOutputStream nos = new NullOutputStream();
        while (iter < 5 && aiter < 10) {
            ++aiter;
            nos.reset();
            try {
                ImaTool.saveJPEG(bi, nos, q);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            sz = (int)nos.getSzWritten();
            if (sz > esz) {
                hiq = q;
                if ((q = (lowq + hiq) / 2.0) == hiq) break;
                if (!(q >= hiq)) continue;
                q /= 2.0;
                continue;
            }
            if (sz >= bsz) break;
            ++iter;
            if (q >= 0.9) break;
            lowq = q;
            q = (hiq + lowq) / 2.0;
        }
        return q;
    }

    public static void saveImageByMime(OutputStream os, BufferedImage bi, String mime) throws Exception {
        if ("image/jpeg".equals(mime) || "image/jpg".equals(mime)) {
            ImaTool.saveJPEG(bi, os, 0.6);
        } else if ("image/gif".equals(mime)) {
            ImaTool.saveGIF(bi, os);
        } else if ("image/png".equals(mime)) {
            ImaTool.savePNG(bi, os);
        } else {
            throw new IllegalStateException("Unsupported mime type for save: " + mime);
        }
    }

    public static Dimension getImageDimension(File resourceFile) throws IOException {
        ImageInputStream in = ImageIO.createImageInputStream(resourceFile);
        return ImaTool.getDimension(in);
    }

    @Nullable
    public static Dimension getImageDimension(@Nonnull InputStream is) throws IOException {
        try (ImageInputStream in = ImageIO.createImageInputStream(is);){
            Dimension dimension = ImaTool.getDimension(in);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Dimension getDimension(ImageInputStream in) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                reader.setInput(in);
                Dimension dimension = new Dimension(reader.getWidth(0), reader.getHeight(0));
                return dimension;
            }
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println("resize=" + ImaTool.resizeWithAspect(100, 100, 500, 391));
        System.out.println("resize2=" + ImaTool.resizeWithAspect(100, 78, 500, 391));
    }
}

