/*
 * Decompiled with CFR 0.152.
 */
package to.etc.smtp;

import to.etc.util.StringTool;

public final class Address {
    private String m_email;
    private String m_name;

    public Address(String email) {
        if (email == null || !StringTool.isValidEmail(email)) {
            throw new IllegalStateException("The string '" + email + "' is not a valid email address.");
        }
        this.m_email = email;
    }

    public Address(String email, String name) {
        this(email);
        if (name.trim().length() == 0) {
            throw new IllegalStateException("Invalid name");
        }
        this.m_name = name;
    }

    public String getEmail() {
        return this.m_email;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        if (this.m_name != null) {
            return this.m_name + " <" + this.m_email + ">";
        }
        return this.m_email;
    }
}

