/*
 * Decompiled with CFR 0.152.
 */
package to.etc.smtp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.smtp.Address;
import to.etc.smtp.IMailAttachment;
import to.etc.smtp.Message;
import to.etc.smtp.SmtpTransport;
import to.etc.util.StringTool;

public class MailBuilder {
    private StringBuilder m_text_sb = new StringBuilder();
    private StringBuilder m_html_sb = new StringBuilder();
    private String m_subject;
    private final boolean m_decorateHtml;
    private List<Attachment> m_attachmentList = new ArrayList<Attachment>();
    private int m_attindex = 1;

    public MailBuilder() {
        this(true);
    }

    private MailBuilder(boolean decorateHTML) {
        this.m_decorateHtml = decorateHTML;
    }

    @Nonnull
    public static MailBuilder createNondecoratedMailBuilder() {
        return new MailBuilder(false);
    }

    public void initialize(String subject) {
        this.m_subject = subject;
        this.m_text_sb.setLength(0);
        this.m_html_sb.setLength(0);
        this.m_attachmentList.clear();
        this.m_attindex = 0;
        if (this.m_decorateHtml) {
            this.m_html_sb.append("<html><head>");
            this.m_html_sb.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
            this.m_html_sb.append("</head>");
            this.m_html_sb.append("<body>");
        }
    }

    public MailBuilder append(String s) {
        this.m_text_sb.append(s);
        StringTool.htmlStringizewithLF(this.m_html_sb, s);
        return this;
    }

    public MailBuilder appendText(String s) {
        this.m_text_sb.append(s);
        return this;
    }

    public StringBuilder getHtmlBuffer() {
        return this.m_html_sb;
    }

    public StringBuilder getTextBuffer() {
        return this.m_text_sb;
    }

    public MailBuilder appendHTML(String s) {
        this.m_html_sb.append(s);
        return this;
    }

    public MailBuilder ttl(String s) {
        this.m_text_sb.append(s);
        this.m_text_sb.append("\n");
        int i = s.length();
        while (--i >= 0) {
            this.m_text_sb.append('=');
        }
        this.m_text_sb.append("\n");
        this.m_html_sb.append("<h2>");
        StringTool.htmlStringize(this.m_html_sb, s);
        this.m_html_sb.append("</h2>\n");
        return this;
    }

    public MailBuilder i(String s) {
        this.m_text_sb.append(s);
        this.m_html_sb.append("<i>");
        StringTool.htmlStringize(this.m_html_sb, s);
        this.m_html_sb.append("</i>");
        return this;
    }

    public MailBuilder b(String s) {
        this.m_text_sb.append(s);
        this.m_html_sb.append("<b>");
        StringTool.htmlStringize(this.m_html_sb, s);
        this.m_html_sb.append("</b>");
        return this;
    }

    public MailBuilder nl() {
        this.m_text_sb.append("\n");
        this.m_html_sb.append("<br>");
        return this;
    }

    public MailBuilder link(String url, String text) {
        this.m_text_sb.append(text);
        this.m_text_sb.append(" (");
        this.m_text_sb.append(url);
        this.m_text_sb.append(")");
        this.m_html_sb.append("<a href=\"");
        this.m_html_sb.append(url);
        this.m_html_sb.append("\">");
        StringTool.htmlStringize(this.m_html_sb, text);
        this.m_html_sb.append("</a>");
        return this;
    }

    public MailBuilder linkNoText(String url, String text) {
        this.m_text_sb.append(url);
        this.m_html_sb.append("<a href=\"");
        this.m_html_sb.append(url);
        this.m_html_sb.append("\">");
        StringTool.htmlStringize(this.m_html_sb, text);
        this.m_html_sb.append("</a>");
        return this;
    }

    public MailBuilder image(String name, File source, String mime) throws Exception {
        String imgkey = name + "-" + this.m_attindex++;
        this.m_text_sb.append("(see attached image ");
        this.m_text_sb.append(imgkey);
        this.m_text_sb.append(") ");
        this.m_html_sb.append("<img src=\"cid:");
        this.m_html_sb.append(imgkey);
        this.m_html_sb.append("\">");
        this.m_attachmentList.add(new Attachment(mime, imgkey, source));
        return this;
    }

    @Nonnull
    public MailBuilder addAttachment(@Nonnull String name, @Nonnull File source) throws Exception {
        this.m_attachmentList.add(new Attachment(this.getMimeByFile(source), name, source));
        return this;
    }

    @Nonnull
    private String getMimeByFile(@Nonnull File file) throws IOException {
        Path path = FileSystems.getDefault().getPath(file.getPath(), new String[0]);
        return Files.probeContentType(path);
    }

    public MailBuilder image(String name, String mime, Attachment a) throws Exception {
        String imgkey = name + "-" + this.m_attindex++;
        this.m_text_sb.append("(see attached image ");
        this.m_text_sb.append(imgkey);
        this.m_text_sb.append(") ");
        this.m_html_sb.append("<img src=\"cid:");
        this.m_html_sb.append(imgkey);
        this.m_html_sb.append("\">");
        a.setMime(mime);
        a.setIdent(imgkey);
        this.m_attachmentList.add(a);
        return this;
    }

    public MailBuilder image(String name, final Class<?> rbase, final String rname, String mime) throws Exception {
        String imgkey = name + "-" + this.m_attindex++;
        this.m_text_sb.append("(see attached image ");
        this.m_text_sb.append(imgkey);
        this.m_text_sb.append(") ");
        this.m_html_sb.append("<img src=\"cid:");
        this.m_html_sb.append(imgkey);
        this.m_html_sb.append("\">");
        Attachment a = new Attachment(mime, imgkey, null){

            @Override
            public InputStream getInputStream() throws Exception {
                InputStream is = rbase.getResourceAsStream(rname);
                if (is == null) {
                    throw new IllegalArgumentException("Missing class resource " + rname + " using base class " + rbase);
                }
                return is;
            }
        };
        this.m_attachmentList.add(a);
        return this;
    }

    public void send(Message m) throws Exception {
        if (this.m_decorateHtml) {
            this.m_html_sb.append("</body></html>\n");
        }
        m.setSubject(this.m_subject);
        m.setBody(this.m_text_sb.toString());
        m.setHtmlBody(this.m_html_sb.toString());
        for (Attachment a : this.m_attachmentList) {
            m.addAttachment(a);
        }
        m.send();
    }

    @Nonnull
    public Message createMessage() {
        Message m = new Message();
        m.setSubject(this.m_subject);
        m.setBody(this.m_text_sb.toString());
        m.setHtmlBody(this.m_html_sb.toString());
        for (Attachment a : this.m_attachmentList) {
            m.addAttachment(a);
        }
        return m;
    }

    public void send(SmtpTransport t, Address from, List<Address> dest) throws Exception {
        Message m = t.createMessage();
        m.setTo(dest);
        m.setFrom(from);
        this.send(m);
    }

    public void send(SmtpTransport t, Address from, Address to) throws Exception {
        Message m = t.createMessage();
        ArrayList<Address> tol = new ArrayList<Address>();
        tol.add(to);
        m.setTo(tol);
        m.setFrom(from);
        this.send(m);
    }

    public static void main(String[] args) throws Exception {
        MailBuilder mb = new MailBuilder();
        mb.initialize("Hello, world");
        mb.append("Test message with").b("html").append("markup").nl();
        Address from = new Address("puzzler@etc.to");
        Address to = new Address("jal@etc.to");
        SmtpTransport tp = new SmtpTransport("127.0.0.1", 2500);
        mb.send(tp, from, to);
    }

    private static class Attachment
    implements IMailAttachment {
        public String mime;
        public String ident;
        public File source;

        public Attachment(String mime, String ident, File source) {
            this.mime = mime;
            this.ident = ident;
            this.source = source;
        }

        @Override
        public String getIdent() {
            return this.ident;
        }

        public void setIdent(String ident) {
            this.ident = ident;
        }

        @Override
        public InputStream getInputStream() throws Exception {
            return new FileInputStream(this.source);
        }

        @Override
        public String getMime() {
            return this.mime;
        }

        public void setMime(String mime) {
            this.mime = mime;
        }
    }
}

