/*
 * Decompiled with CFR 0.152.
 */
package to.etc.smtp;

import java.io.IOException;
import java.io.OutputStream;

public class QuotedPrintableOutputStream
extends OutputStream {
    private OutputStream m_os;
    private int m_llen;
    private int m_ineol;

    public QuotedPrintableOutputStream(OutputStream os) {
        this.m_os = os;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13) {
            if (this.m_ineol != 0) {
                throw new IllegalStateException("Unexpected 0x0d-0x0d (2x) in input. All lines should have crlf endings");
            }
            this.m_os.write(b);
            this.m_ineol = 1;
        } else if (b == 10) {
            if (this.m_ineol == 0) {
                throw new IllegalStateException("Unexpected single 0x0a in input. All lines should have crlf endings");
            }
            this.m_os.write(10);
            this.m_llen = 0;
            this.m_ineol = 0;
        } else if (this.m_llen >= 76) {
            // empty if block
        }
    }
}

