/*
 * Decompiled with CFR 0.152.
 */
package to.etc.telnet;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import to.etc.util.StringTool;

public class ExtendedPrintWriter
extends PrintWriter {
    public static final int STR = 0;
    public static final int INT = 1;
    public static final int COMMAD = 2;
    public static final int SIZE = 3;
    public static final int STRTRUNC = 4;
    private static final FSpec NULL_FSPEC = new FSpec(0, -1, "", false);
    private List<FSpec> m_flist = new ArrayList<FSpec>();
    private boolean m_init;
    private int m_index;

    public ExtendedPrintWriter(Writer out) {
        super(out);
    }

    public void print(String s, int width) {
        int len = s.length();
        while (len++ < width) {
            this.print(' ');
        }
    }

    public void printright(String s, int width) {
        int len = s.length();
        while (len++ < width) {
            this.print(' ');
        }
        this.print(s);
    }

    public void print(long value, int width) {
        this.printright(Long.toString(value), width);
    }

    public void printCommad(long value, int width) {
        this.printright(StringTool.strCommad(value), width);
    }

    public void printSize(long value, int width) {
        this.print(StringTool.strSize(value), width);
    }

    public void clear() {
        this.m_flist.clear();
        if (this.m_index > 0) {
            this.done();
        }
        this.m_init = false;
    }

    public void add(int width, int format, String header, boolean right) {
        this.m_flist.add(new FSpec(width, format, header, right));
    }

    public void add(int width, int format, String header) {
        this.m_flist.add(new FSpec(width, format, header, false));
    }

    public void header(String hdr, int type) {
        this.add(hdr.length(), type, hdr, type == 1 || type == 2);
    }

    private void init() {
        if (!this.m_init) {
            for (FSpec s : this.m_flist) {
                if (this.m_init) {
                    this.print(' ');
                }
                this.print(s.m_header);
                this.m_init = true;
            }
            this.m_init = true;
            this.println();
        }
    }

    private FSpec current() {
        if (this.m_index >= this.m_flist.size()) {
            return NULL_FSPEC;
        }
        return this.m_flist.get(this.m_index);
    }

    public void out(String s) {
        this.init();
        FSpec f = this.current();
        ++this.m_index;
        if (this.m_index != 1) {
            this.print(' ');
        }
        int len = s.length();
        if (f.m_type == 4 && len > f.m_width) {
            s = s.substring(0, f.m_width);
            len = f.m_width;
        }
        if (f.m_right) {
            while (len++ < f.m_width) {
                this.print(' ');
            }
        }
        this.print(s);
        if (!f.m_right) {
            while (len++ < f.m_width) {
                this.print(' ');
            }
        }
        if (this.m_index >= this.m_flist.size()) {
            this.m_index = 0;
            this.println();
        }
    }

    public void done() {
        if (this.m_index > 0) {
            this.m_index = 0;
            this.println();
        }
    }

    public void out(long v) {
        this.init();
        FSpec f = this.current();
        switch (f.m_type) {
            case 2: {
                this.out(StringTool.strCommad(v));
                break;
            }
            case 3: {
                this.out(StringTool.strSize(v));
                break;
            }
            default: {
                this.out(Long.toString(v));
            }
        }
    }

    private static class FSpec {
        public String m_header;
        public int m_type;
        public int m_width;
        public boolean m_right;

        public FSpec(int width, int type, String header, boolean right) {
            this.m_width = width;
            this.m_type = type;
            this.m_header = header;
            this.m_right = right;
        }
    }
}

