/*
 * Decompiled with CFR 0.152.
 */
package to.etc.telnet;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import to.etc.telnet.ITelnetClientEvent;
import to.etc.telnet.TelnetPrintWriter;
import to.etc.telnet.TelnetServer;
import to.etc.telnet.TelnetStateThing;
import to.etc.telnet.TelnetWriter;

public class TelnetSession
extends TelnetStateThing
implements Runnable {
    private TelnetServer m_server;
    private Socket m_s;
    private Thread m_reader_thread;
    private InputStream m_is;
    private OutputStream m_os;
    private PrintWriter m_pw;
    private String m_name;
    private StringBuffer m_cmd_sb;
    private TelnetPrintWriter m_tpw;
    private int m_screen_mode;
    private long m_ts_input;
    private LinkedList<String> m_pending_output_ll = new LinkedList();
    private int m_last_inchar;
    private StringBuffer m_esc_sb = new StringBuffer(8);
    private Map<String, Object> m_clientdata_ht = new HashMap<String, Object>(11);

    protected TelnetSession(TelnetServer srv, Socket s) {
        this.m_s = s;
        this.m_server = srv;
        StringBuffer sb = new StringBuffer(40);
        sb.append(this.m_s.getInetAddress().toString());
        sb.append(":");
        sb.append(Integer.toString(this.m_s.getPort()));
        this.m_name = sb.toString();
        this.m_cmd_sb = new StringBuffer(80);
        this.m_tpw = new TelnetPrintWriter(new TelnetWriter(this));
    }

    public String getName() {
        return this.m_name;
    }

    public void init() throws Exception {
        System.out.println("TelnetServer: accepted session with " + this.getName());
        try {
            this.m_is = this.m_s.getInputStream();
            this.m_os = this.m_s.getOutputStream();
            this.m_pw = new PrintWriter(this.m_os);
            this.m_reader_thread = new Thread(this);
            this.m_reader_thread.setDaemon(true);
            this.m_reader_thread.setName("TelnetClient:" + this.getName());
            this.setState(4);
            this.m_reader_thread.start();
        }
        finally {
            if (!this.inState(1) && !this.inState(4)) {
                this.releaseResources();
            }
        }
    }

    private void releaseResources() {
        this.setState(3);
        try {
            if (this.m_is != null) {
                this.m_is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.m_os != null) {
                this.m_os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_is = null;
        this.m_os = null;
        this.m_s = null;
        this.releaseAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toNormalMode() throws Exception {
        LinkedList<String> linkedList = this.m_pending_output_ll;
        synchronized (linkedList) {
            if (this.m_screen_mode == 0) {
                return;
            }
            try {
                this._write("\r\n");
                while (!this.m_pending_output_ll.isEmpty()) {
                    String s = this.m_pending_output_ll.removeFirst();
                    this._write(s);
                }
            }
            finally {
                this.m_pending_output_ll.clear();
                this.m_screen_mode = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toInputMode() throws Exception {
        LinkedList<String> linkedList = this.m_pending_output_ll;
        synchronized (linkedList) {
            if (this.m_screen_mode != 0) {
                return;
            }
            this._write("\r\nWhat? >");
            this._write(this.m_cmd_sb.toString());
            this.m_ts_input = System.currentTimeMillis() + 10000L;
            this.m_screen_mode = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) throws Exception {
        LinkedList<String> linkedList = this.m_pending_output_ll;
        synchronized (linkedList) {
            long t;
            if (this.m_screen_mode == 0) {
                this._write(s);
                return;
            }
            this.m_pending_output_ll.addLast(s);
            if (this.m_pending_output_ll.size() > 300) {
                this.m_pending_output_ll.removeFirst();
            }
            if ((t = System.currentTimeMillis()) > this.m_ts_input) {
                this.toNormalMode();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _write(String s) throws Exception {
        if (!this.inState(1) && !this.inState(4)) {
            return;
        }
        try {
            LinkedList<String> linkedList = this.m_pending_output_ll;
            synchronized (linkedList) {
                int ix = 0;
                int sl = s.length();
                while (ix < sl) {
                    int pos = s.indexOf(10, ix);
                    if (pos == -1) {
                        this.m_pw.print(s.substring(ix));
                        break;
                    }
                    this.m_pw.print(s.substring(ix, pos));
                    this.m_pw.print("\r\n");
                    ix = pos + 1;
                }
                this.m_pw.flush();
            }
        }
        catch (Exception x) {
            this.handleFatalError(x);
        }
    }

    private void handleFatalError(Exception x) throws Exception {
        this.setState(3);
        x.printStackTrace();
        this.releaseResources();
        this.m_server.sessionClosed(this);
    }

    private void normalClose() throws Exception {
        this.setState(3);
        this.releaseResources();
        this.m_server.sessionClosed(this);
        System.out.println("Telnet " + this.getName() + ": connection terminated normally");
    }

    public void close() {
        try {
            this.normalClose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        System.out.println("Telnet " + this.getName() + ": starting reader thread..");
        this.setState(1);
        try {
            this.write("Welcome to the Java Loggger Telnet Server. Enter ? to get a list of commands.\r\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (this.readInputAndHandleIt()) {
            }
            this.normalClose();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            this.setState(3);
        }
        System.out.println("Telnet " + this.getName() + ": reader thread TERMINATED..");
    }

    private boolean readInputAndHandleIt() throws Exception {
        if (!this.inState(1)) {
            return false;
        }
        int c = this.m_is.read();
        if (c == -1) {
            return false;
        }
        this.appendCommand(c);
        return true;
    }

    private void appendCommand(int c) {
        if (this.m_esc_sb.length() > 0 && this.keyEscapeSequence(c)) {
            return;
        }
        try {
            if (c == 13 || c == 10) {
                if (this.m_last_inchar == 13 && c == 10) {
                    return;
                }
                if (this.m_last_inchar == 10 && c == 13) {
                    return;
                }
                this.keyReturn();
                return;
            }
            this.toInputMode();
            if (c == 27) {
                this.keyEscapeSequence(c);
                return;
            }
            if (c == 8) {
                this.keyBackspace();
                return;
            }
            if (c == 127) {
                this.keyDelete();
                return;
            }
            this.m_cmd_sb.append((char)c);
            this._write(this.m_cmd_sb.toString().substring(this.m_cmd_sb.length() - 1));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        finally {
            this.m_last_inchar = c;
        }
    }

    private void keyReturn() {
        try {
            this.toNormalMode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String cmd = this.m_cmd_sb.toString().trim();
        if (cmd.length() > 0) {
            this.m_server.executeTelnetCommand(this.m_tpw, cmd);
            this.m_tpw.flush();
        }
        this.m_cmd_sb.setLength(0);
    }

    private boolean keyEscapeSequence(int ch) {
        this.m_esc_sb.append((char)ch);
        if (this.m_esc_sb.length() >= 3) {
            this.m_esc_sb.setLength(0);
        }
        return true;
    }

    private void keyBackspace() throws Exception {
        int cl = this.m_cmd_sb.length();
        if (cl <= 0) {
            return;
        }
        this.m_cmd_sb.setLength(cl - 1);
        this._write("\b \b");
    }

    private void keyDelete() throws Exception {
        int cl = this.m_cmd_sb.length();
        if (cl <= 0) {
            return;
        }
        this.m_cmd_sb.setLength(cl - 1);
        this._write("\b \b");
    }

    public synchronized void put(String n, Object o) {
        if (this.inState(3) || this.inState(2)) {
            return;
        }
        this.m_clientdata_ht.put(n, o);
    }

    public synchronized Object get(String name) {
        return this.m_clientdata_ht.get(name);
    }

    private synchronized void releaseAllData() {
        for (Object o : this.m_clientdata_ht.values()) {
            if (!(o instanceof ITelnetClientEvent)) continue;
            ((ITelnetClientEvent)o).sessionClosed(this);
        }
        this.m_clientdata_ht.clear();
    }
}

