/*
 * Decompiled with CFR 0.152.
 */
package to.etc.template;

import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import to.etc.template.IJSTemplateContext;
import to.etc.template.JSLocationMapping;
import to.etc.template.JSTemplateCompiler;
import to.etc.template.JSTemplateError;

public class JSTemplate {
    private final String m_source;
    private final ScriptEngine m_engine;
    private final CompiledScript m_code;
    private final List<JSLocationMapping> m_locMap;

    public JSTemplate(String source, ScriptEngine engine, CompiledScript code, List<JSLocationMapping> locMap) {
        this.m_source = source;
        this.m_engine = engine;
        this.m_code = code;
        this.m_locMap = locMap;
    }

    public final String getSource() {
        return this.m_source;
    }

    public Object execute(IJSTemplateContext tc, Object ... assignments) {
        Bindings xb = this.m_engine.createBindings();
        for (int i = 0; i < assignments.length; i += 2) {
            String name = (String)assignments[i];
            Object val = assignments[i + 1];
            xb.put(name, val);
        }
        xb.put("out", (Object)tc);
        try {
            return this.m_code.eval(xb);
        }
        catch (ScriptException sx) {
            int[] res = JSTemplateCompiler.remapLocation(this.m_locMap, sx.getLineNumber(), sx.getColumnNumber());
            throw new JSTemplateError(sx, sx.getMessage(), this.m_source, res[0], res[1]);
        }
    }

    public Object execute(IJSTemplateContext tc, Map<String, Object> assignments) {
        Bindings xb = this.m_engine.createBindings();
        for (Map.Entry<String, Object> me : assignments.entrySet()) {
            xb.put(me.getKey(), me.getValue());
        }
        xb.put("out", (Object)tc);
        try {
            return this.m_code.eval(xb);
        }
        catch (ScriptException sx) {
            int[] res = JSTemplateCompiler.remapLocation(this.m_locMap, sx.getLineNumber(), sx.getColumnNumber());
            throw new JSTemplateError(sx, sx.getMessage(), this.m_source, res[0], res[1]);
        }
    }

    private IJSTemplateContext createContext(final Appendable a) {
        return new IJSTemplateContext(){

            @Override
            public void writeValue(Object v) throws Exception {
                if (v == null) {
                    return;
                }
                if (v instanceof Double) {
                    String res = v.toString();
                    if (res.endsWith(".0")) {
                        res = res.substring(0, res.length() - 2);
                    }
                    a.append(res);
                } else {
                    a.append(v.toString());
                }
            }

            @Override
            public void write(String text) throws Exception {
                a.append(text);
            }
        };
    }

    public Object execute(Appendable a, Object ... assignments) {
        return this.execute(this.createContext(a), assignments);
    }

    public Object execute(Appendable a, Map<String, Object> assignments) {
        return this.execute(this.createContext(a), assignments);
    }
}

