/*
 * Decompiled with CFR 0.152.
 */
package to.etc.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import to.etc.template.IJSTemplateContext;
import to.etc.template.JSLocationMapping;
import to.etc.template.JSTemplate;
import to.etc.template.JSTemplateError;
import to.etc.util.FileTool;

public class JSTemplateCompiler {
    private StringBuilder m_sb = new StringBuilder(1024);
    private StringBuilder m_jsb = new StringBuilder(1024);
    private Reader m_r;
    private String m_source;
    private int m_line;
    private int m_col;
    private int m_pushed;
    private int m_oline;
    private List<JSLocationMapping> m_mapList;
    private Pha m_pha;
    private Pha m_opha;
    @Nonnull
    private List<JSLib> m_libraryList = new ArrayList<JSLib>();

    public void addLibrary(String identifier, String sourceCode) {
        this.m_libraryList.add(new JSLib(sourceCode, identifier));
    }

    public void addLibrary(File input) throws Exception {
        this.addLibrary(input.toString(), FileTool.readFileAsString(input, "utf-8"));
    }

    public void addLibrary(Class<?> resourceClass, String name) throws Exception {
        this.addLibrary(resourceClass.getName() + ":" + name, FileTool.readResourceAsString(resourceClass, name, "utf-8"));
    }

    @Nonnull
    public JSTemplate compile(Reader input, String sourceName) throws Exception {
        this.m_source = sourceName;
        this.translate(input);
        return this.compile();
    }

    public String getTranslation() {
        return this.m_jsb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public JSTemplate compile(@Nonnull Class<?> clz, @Nonnull String resource, @Nullable String encoding) throws Exception {
        InputStream is;
        if (null == encoding) {
            encoding = "utf-8";
        }
        if (null == (is = clz.getResourceAsStream(resource))) {
            throw new IllegalArgumentException("No class resource " + clz + ":" + resource + " found");
        }
        try {
            InputStreamReader r = new InputStreamReader(is, encoding);
            JSTemplate jSTemplate = this.compile(r, clz.getName() + ":" + resource);
            return jSTemplate;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void execute(Appendable res, Reader input, String sourceName, Object ... assignments) throws Exception {
        JSTemplate tmpl = this.compile(input, sourceName);
        tmpl.execute(res, assignments);
    }

    public void execute(IJSTemplateContext tc, Reader input, String sourceName, Object ... assignments) throws Exception {
        JSTemplate tmpl = this.compile(input, sourceName);
        tmpl.execute(tc, assignments);
    }

    public Object execute(Appendable res, Class<?> clz, String resource, Object ... assignments) throws Exception {
        JSTemplate tmpl = this.compile(clz, resource, "utf-8");
        return tmpl.execute(res, assignments);
    }

    public void execute(IJSTemplateContext tc, Reader input, String sourceName, Map<String, Object> assignments) throws Exception {
        JSTemplate tmpl = this.compile(input, sourceName);
        tmpl.execute(tc, assignments);
    }

    public void executeMap(Appendable tc, Reader input, String sourceName, Map<String, Object> assignments) throws Exception {
        JSTemplate tmpl = this.compile(input, sourceName);
        tmpl.execute(tc, assignments);
    }

    public Object executeMap(Appendable res, Class<?> clz, String resource, Map<String, Object> assignments) throws Exception {
        JSTemplate tmpl = this.compile(clz, resource, "utf-8");
        return tmpl.execute(res, assignments);
    }

    private JSTemplate compile() throws Exception {
        ScriptEngineManager sem = new ScriptEngineManager();
        ScriptEngine jsengine = sem.getEngineByName("js");
        if (!(jsengine instanceof Compilable)) {
            throw new IllegalStateException("Got Javascript engine " + jsengine + " which cannot compile Javascripts!?");
        }
        Compilable compiler = (Compilable)((Object)jsengine);
        jsengine.getBindings(100).put("javax.script.filename", (Object)this.m_source);
        for (JSLib l : this.m_libraryList) {
            this.m_jsb.append("\n;\n");
            this.m_jsb.append(l.getSource());
        }
        String js = this.m_jsb.toString();
        try {
            CompiledScript cs = compiler.compile(js);
            return new JSTemplate(this.m_source, jsengine, cs, this.m_mapList);
        }
        catch (ScriptException sx) {
            int[] res = JSTemplateCompiler.remapLocation(this.m_mapList, sx.getLineNumber(), sx.getColumnNumber());
            throw new JSTemplateError(sx.getMessage(), this.m_source, res[0], res[1]);
        }
    }

    public static int[] remapLocation(List<JSLocationMapping> mapList, int lineNumber, int columnNumber) {
        int i = mapList.size();
        while (--i >= 0) {
            JSLocationMapping m = mapList.get(i);
            if (m.getTline() > lineNumber || m.getTcol() > columnNumber) continue;
            int dline = lineNumber - m.getTline();
            int dcol = columnNumber - m.getTcol();
            return new int[]{m.getSline() + dline, m.getScol() + dcol};
        }
        return new int[]{lineNumber, columnNumber};
    }

    protected void translate(Reader input) throws Exception {
        if (!(input instanceof BufferedReader)) {
            input = new BufferedReader(input);
        }
        this.m_r = input;
        this.m_jsb.setLength(0);
        this.m_line = 0;
        this.m_col = 0;
        this.m_pha = Pha.LIT;
        this.m_pushed = -1;
        this.m_mapList = new ArrayList<JSLocationMapping>();
        int scol = 0;
        int sline = 0;
        while (true) {
            int c;
            if ((c = this.la()) == -1) {
                if (this.m_pha != Pha.LIT) {
                    this.error("Unexpected end-of-file.");
                }
                this.flushLiteral();
                return;
            }
            switch (this.m_pha) {
                default: {
                    throw new IllegalStateException("Bad pha");
                }
                case LIT: {
                    if (c == 60) {
                        this.m_pha = Pha.LT;
                        break;
                    }
                    this.m_sb.append((char)c);
                    break;
                }
                case LT: {
                    if (c == 37) {
                        this.m_pha = Pha.PCT;
                        this.flushLiteral();
                        sline = this.m_line;
                        scol = this.m_col;
                        break;
                    }
                    this.m_sb.append('<');
                    this.m_pha = Pha.LIT;
                    this.push(c);
                    break;
                }
                case PCT: {
                    if (c == 61) {
                        this.m_pha = Pha.XPR;
                        break;
                    }
                    this.m_pha = Pha.CODE;
                    this.m_sb.append((char)c);
                    break;
                }
                case XPR: 
                case CODE: {
                    if (c == 37) {
                        this.m_opha = this.m_pha;
                        this.m_pha = Pha.EPCT;
                        break;
                    }
                    this.m_sb.append((char)c);
                    break;
                }
                case EPCT: {
                    if (c == 62) {
                        this.m_pha = Pha.LIT;
                        this.flushJavascript(this.m_opha == Pha.XPR, sline, scol);
                        break;
                    }
                    this.m_sb.append('%');
                    this.m_pha = this.m_opha;
                }
            }
            if (c == 10) {
                ++this.m_line;
                this.m_col = 0;
                continue;
            }
            ++this.m_col;
        }
    }

    private void addMapping(int oline, int ocol, int line, int col) {
        JSLocationMapping m = new JSLocationMapping(oline, ocol, line, col);
        this.m_mapList.add(m);
    }

    private void flushJavascript(boolean isexpr, int sline, int scol) {
        String code = this.m_sb.toString();
        this.m_sb.setLength(0);
        if (isexpr) {
            this.m_jsb.append("__tv=");
            this.addMapping(this.m_oline, 5, sline, scol);
            this.m_jsb.append(code);
            this.m_jsb.append(";\n");
            ++this.m_oline;
            this.m_jsb.append("out.writeValue(__tv);\n");
            ++this.m_oline;
            return;
        }
        this.addMapping(this.m_oline, 0, sline, scol);
        this.m_jsb.append(code);
        this.m_jsb.append('\n');
        ++this.m_oline;
    }

    private void flushLiteral() {
        this.m_jsb.append("out.write(");
        JSTemplateCompiler.strToJavascriptString(this.m_jsb, this.m_sb, true);
        this.m_jsb.append(");\n");
        ++this.m_oline;
        this.m_sb.setLength(0);
    }

    public static void strToJavascriptString(StringBuilder w, CharSequence cs, boolean dblquote) {
        int len = cs.length();
        char quotechar = dblquote ? (char)'\"' : '\'';
        w.append(quotechar);
        block10: for (int ix = 0; ix < len; ++ix) {
            int runstart = ix;
            char c = '\u0000';
            while (ix < len && (c = cs.charAt(ix)) >= ' ' && c != '\'' && c != '\\' && c != quotechar) {
                ++ix;
            }
            if (ix > runstart) {
                w.append(cs, runstart, ix);
                if (ix >= len) break;
            }
            switch (c) {
                default: {
                    w.append("\\u");
                    JSTemplateCompiler.intToStr(w, c & 0xFFFF, 16, 4);
                    continue block10;
                }
                case '\n': {
                    w.append("\\n");
                    continue block10;
                }
                case '\b': {
                    w.append("\\b");
                    continue block10;
                }
                case '\f': {
                    w.append("\\f");
                    continue block10;
                }
                case '\r': {
                    w.append("\\r");
                    continue block10;
                }
                case '\t': {
                    w.append("\\t");
                    continue block10;
                }
                case '\'': {
                    w.append("\\'");
                    continue block10;
                }
                case '\"': {
                    w.append("\\\"");
                    continue block10;
                }
                case '\\': 
            }
            w.append("\\\\");
        }
        w.append(quotechar);
    }

    private static void intToStr(StringBuilder w, int value, int radix, int len) {
        String v = Integer.toString(value, radix);
        for (int sl = v.length(); sl < len; ++sl) {
            w.append('0');
        }
        w.append(v);
    }

    private void push(int c) {
        if (this.m_pushed != -1) {
            throw new IllegalStateException("Dup push");
        }
        this.m_pushed = c;
    }

    private int la() throws IOException {
        if (this.m_pushed != -1) {
            int c = this.m_pushed;
            this.m_pushed = -1;
            return c;
        }
        return this.m_r.read();
    }

    protected void error(String string) {
        throw new JSTemplateError(string, this.m_source, this.m_line, this.m_col);
    }

    private class JSLib {
        private String m_source;
        private String m_identifier;

        public JSLib(String source, String identifier) {
            this.m_source = source;
            this.m_identifier = identifier;
        }

        public String getIdentifier() {
            return this.m_identifier;
        }

        public String getSource() {
            return this.m_source;
        }
    }

    private static enum Pha {
        LIT,
        LT,
        PCT,
        XPR,
        CODE,
        EPCT;

    }
}

