/*
 * Decompiled with CFR 0.152.
 */
package to.etc.template;

import java.util.List;
import to.etc.template.JSLocationMapping;

public class JSTemplateError
extends RuntimeException {
    private String m_source;
    private int m_line;
    private int m_column;

    public JSTemplateError(String message, String source, int line, int column) {
        super(message);
        this.m_source = source;
        this.m_line = line;
        this.m_column = column;
    }

    public JSTemplateError(Throwable x, String message, String source, int line, int column) {
        super(message, x);
        this.m_source = source;
        this.m_line = line;
        this.m_column = column;
    }

    public static int[] remapLocation(List<JSLocationMapping> mapList, int lineNumber, int columnNumber) {
        int i = mapList.size();
        while (--i >= 0) {
            JSLocationMapping m = mapList.get(i);
            if (m.getTline() > lineNumber || m.getTcol() > columnNumber) continue;
            int dline = lineNumber - m.getTline();
            int dcol = columnNumber - m.getTcol();
            return new int[]{m.getSline() + dline, m.getScol() + dcol};
        }
        return new int[]{lineNumber, columnNumber};
    }

    public int getColumn() {
        return this.m_column;
    }

    public int getLine() {
        return this.m_line;
    }

    public String getSource() {
        return this.m_source;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_source != null) {
            sb.append(this.m_source);
        }
        if (this.m_line != -1 || this.m_column != -1) {
            sb.append('(');
            if (this.m_line != -1) {
                sb.append(this.m_line);
            }
            if (this.m_column != -1) {
                sb.append(':');
                sb.append(this.m_column);
            }
            sb.append(") ");
        } else if (this.m_source != null) {
            sb.append(": ");
        }
        sb.append(this.getMessage());
        return sb.toString();
    }
}

