/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.OutputStream;
import to.etc.util.StringTool;

public class Base64OutputStream
extends OutputStream {
    private OutputStream m_os;
    private boolean m_close;
    private byte[] m_buf = new byte[3];
    private int m_holdix;
    private int m_lineLen;
    private static final byte[] BASE64MAP = StringTool.getBase64Map();

    public Base64OutputStream(OutputStream os, boolean close) {
        this.m_os = os;
        this.m_close = close;
    }

    @Override
    public void close() throws IOException {
        if (this.m_os == null) {
            return;
        }
        if (this.m_lineLen >= 72) {
            this.m_os.write("\r\n".getBytes());
            this.m_lineLen = 0;
        }
        switch (this.m_holdix) {
            default: {
                throw new IllegalStateException(this.m_holdix + " !?!?");
            }
            case 0: {
                break;
            }
            case 1: {
                this.m_os.write(BASE64MAP[this.m_buf[0] >>> 2 & 0x3F]);
                this.m_os.write(BASE64MAP[this.m_buf[0] << 4 & 0x3F]);
                this.m_os.write(61);
                this.m_os.write(61);
                this.m_lineLen += 4;
                break;
            }
            case 2: {
                this.m_os.write(BASE64MAP[this.m_buf[0] >>> 2 & 0x3F]);
                this.m_os.write(BASE64MAP[this.m_buf[1] >>> 4 & 0xF | this.m_buf[0] << 4 & 0x3F]);
                this.m_os.write(BASE64MAP[this.m_buf[1] << 2 & 0x3F]);
                this.m_os.write(61);
                this.m_lineLen += 4;
            }
        }
        if (this.m_close) {
            this.m_os.close();
        }
        this.m_os = null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        if (this.m_holdix > 0) {
            while (this.m_holdix < 3) {
                if (len <= 0) {
                    return;
                }
                this.m_buf[this.m_holdix++] = b[off++];
                --len;
            }
            this.encodePart(this.m_buf, 0, 3);
            this.m_holdix = 0;
        }
        if (len <= 0) {
            return;
        }
        int tbp = len / 3 * 3;
        if (tbp > 0) {
            this.encodePart(b, off, tbp);
            len -= tbp;
            off += tbp;
        }
        while (len-- > 0) {
            this.m_buf[this.m_holdix++] = b[off++];
        }
    }

    private void encodePart(byte[] data, int off, int len) throws IOException {
        int eidx = off + len;
        for (int sidx = off; sidx < eidx; sidx += 3) {
            if (this.m_lineLen >= 72) {
                this.m_os.write("\r\n".getBytes());
                this.m_lineLen = 0;
            }
            this.m_os.write(BASE64MAP[data[sidx] >>> 2 & 0x3F]);
            this.m_os.write(BASE64MAP[data[sidx + 1] >>> 4 & 0xF | data[sidx] << 4 & 0x3F]);
            this.m_os.write(BASE64MAP[data[sidx + 2] >>> 6 & 3 | data[sidx + 1] << 2 & 0x3F]);
            this.m_os.write(BASE64MAP[data[sidx + 2] & 0x3F]);
            this.m_lineLen += 4;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.m_buf[this.m_holdix++] = (byte)b;
        if (this.m_holdix < 3) {
            return;
        }
        this.encodePart(this.m_buf, 0, 3);
        this.m_holdix = 0;
    }
}

