/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class BoolVector {
    private byte[] m_ar;
    private int m_count;

    public BoolVector() {
        this(256);
    }

    public BoolVector(int cap) {
        if (cap <= 0) {
            cap = 256;
        }
        this.m_ar = new byte[(cap + 7) / 8];
        this.m_count = 0;
    }

    public boolean set(int ix, boolean value) {
        int msk;
        byte v;
        boolean res;
        int i;
        if (ix >= this.m_count) {
            this.m_count = ix + 1;
        }
        if ((i = ix / 8) >= this.m_ar.length) {
            if (!value) {
                return false;
            }
            byte[] ar = new byte[i + 128];
            System.arraycopy(this.m_ar, 0, ar, 0, this.m_ar.length);
            this.m_ar = ar;
        }
        boolean bl = res = ((v = this.m_ar[i]) & (msk = 1 << (ix & 7))) != 0;
        if (value) {
            int n = i;
            this.m_ar[n] = (byte)(this.m_ar[n] | msk);
        } else {
            int n = i;
            this.m_ar[n] = (byte)(this.m_ar[n] & ~msk);
        }
        return res;
    }

    public boolean get(int ix) {
        int i = ix / 8;
        if (i >= this.m_ar.length) {
            return false;
        }
        int msk = 1 << (ix & 7);
        return 0 != (this.m_ar[i] & msk);
    }

    public int size() {
        return this.m_count;
    }

    public int capacity() {
        return this.m_ar.length * 8;
    }

    public void or(BoolVector bv) {
        if (bv.m_count > this.m_count) {
            this.m_count = bv.m_count;
        }
        byte[] s1 = bv.m_ar;
        if (this.m_ar.length < bv.m_ar.length) {
            byte[] s2 = this.m_ar;
            this.m_ar = new byte[bv.m_ar.length];
            int i = s2.length;
            while (--i >= 0) {
                this.m_ar[i] = (byte)(s1[i] | s2[i]);
            }
            System.arraycopy(s1, s2.length, this.m_ar, s2.length, this.m_ar.length - s2.length);
        } else {
            int i = s1.length;
            while (--i >= 0) {
                int n = i;
                this.m_ar[n] = (byte)(this.m_ar[n] | s1[i]);
            }
        }
    }
}

