/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.sql.Timestamp;
import java.util.List;

public final class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static void setLong(byte[] ba, int offset, long val) {
        ByteArrayUtil.setInt(ba, offset, (int)val);
        ByteArrayUtil.setInt(ba, offset + 4, (int)(val >> 32));
    }

    public static long getLong(byte[] ba, int offset) {
        long a = ByteArrayUtil.getInt(ba, offset + 4);
        long b = ByteArrayUtil.getInt(ba, offset);
        b &= 0xFFFFFFFFL;
        return b |= (a <<= 32);
    }

    public static void setTimestamp(byte[] ba, int offset, Timestamp val) {
        ByteArrayUtil.setLong(ba, offset, val == null ? 0L : val.getTime());
    }

    public static Timestamp getTimestamp(byte[] ar, int offset) {
        long l = ByteArrayUtil.getLong(ar, offset);
        return l == 0L ? null : new Timestamp(l);
    }

    public static void setShort(byte[] ba, int offset, short val) {
        ba[offset] = (byte)(val >> 8 & 0xFF);
        ba[offset + 1] = (byte)(val & 0xFF);
    }

    public static short getShort(byte[] ba, int offset) {
        return (short)((ba[offset] << 8 | ba[offset + 1] & 0xFF) & 0xFFFF);
    }

    public static void setInt(byte[] ba, int offset, int val) {
        byte b;
        int x = val >> 24 & 0xFF;
        ba[offset] = b = (byte)x;
        x = val >> 16 & 0xFF;
        ba[offset + 1] = b = (byte)x;
        x = val >> 8 & 0xFF;
        ba[offset + 2] = b = (byte)x;
        x = val & 0xFF;
        ba[offset + 3] = b = (byte)x;
    }

    public static int getInt(byte[] ba, int offset) {
        int val = ba[offset + 3] & 0xFF;
        val |= (ba[offset] & 0xFF) << 24;
        val |= (ba[offset + 1] & 0xFF) << 16;
        return val |= (ba[offset + 2] & 0xFF) << 8;
    }

    public static void setString(byte[] ba, int offset, String s, int length) {
        int i;
        int l = s.length();
        if (l > length) {
            l = length;
        }
        for (i = 0; i < l; ++i) {
            ba[offset++] = (byte)(s.charAt(i) & 0xFF);
        }
        while (i++ < length) {
            ba[offset++] = 0;
        }
    }

    public static String getString(byte[] ar, int offset, int length) {
        char[] c = new char[length];
        int ix = 0;
        while (ix < length && ar[offset] != 0) {
            c[ix] = (char)(ar[offset] & 0xFF);
            ++ix;
            ++offset;
        }
        return new String(c, 0, ix);
    }

    public static int compare(byte[] a, int from, int to, byte[] b) {
        int sx = 0;
        int rv = 0;
        int i = from;
        while (i < to) {
            rv = sx < b.length ? (a[i] & 0xFF) - (b[sx] & 0xFF) : a[i];
            if (rv != 0) {
                return rv > 0 ? -1 : 1;
            }
            ++i;
            ++sx;
        }
        return 0;
    }

    public static int compare(byte[] a, int astart, byte[] b, int bstart, int len) {
        while (len-- > 0) {
            int rv;
            if ((rv = a[astart++] - b[bstart++]) < 0) {
                return -1;
            }
            if (rv <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static int findKey(List<byte[]> v, int start, byte[] key) {
        int low = 0;
        int high = v.size();
        while (low < high) {
            int mid = (low + high) / 2;
            byte[] ba = v.get(mid);
            int rv = ByteArrayUtil.compare(ba, start, key.length, key);
            if (rv == 0) {
                return mid;
            }
            if (rv < 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }
}

