/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteBufferInputStream
extends InputStream {
    private byte[][] m_data;
    private int m_sz;
    private int m_off;
    private int m_bufix;
    private int m_bufoff;

    public ByteBufferInputStream(byte[][] data) {
        this.m_data = data;
        this.m_sz = this.calcDataSize();
    }

    private void setReadPos(int pos) {
        this.m_bufix = 0;
        this.m_off = 0;
        while (this.m_bufix < this.m_data.length) {
            int epos = this.m_off + this.m_data[this.m_bufix].length;
            if (epos > pos) {
                this.m_bufoff = pos - this.m_off;
                this.m_off = pos;
                return;
            }
            this.m_off = epos;
            ++this.m_bufix;
        }
        this.m_off = this.m_sz;
    }

    private final int calcDataSize() {
        int sz = 0;
        int i = this.m_data.length;
        while (--i >= 0) {
            byte[] d = this.m_data[i];
            if (d == null) continue;
            sz += d.length;
        }
        return sz;
    }

    @Override
    public long skip(long n) throws IOException {
        this.m_off += (int)n;
        this.setReadPos(this.m_off);
        return this.m_off;
    }

    @Override
    public int read(byte[] parm1) throws IOException {
        return this.read(parm1, 0, parm1.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.setReadPos(0);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        int sz = this.m_sz - this.m_off;
        if (sz < 0) {
            return 0;
        }
        return sz;
    }

    @Override
    public int read() throws IOException {
        if (this.m_off >= this.m_sz) {
            return -1;
        }
        byte[] buf = this.m_data[this.m_bufix];
        if (this.m_bufoff < buf.length) {
            ++this.m_off;
            return buf[this.m_bufoff++] & 0xFF;
        }
        ++this.m_bufix;
        buf = this.m_data[this.m_bufix];
        this.m_bufoff = 1;
        ++this.m_off;
        return buf[0] & 0xFF;
    }

    @Override
    public int read(byte[] odata, int ooff, int osz) throws IOException {
        int rsz;
        if (this.m_off >= this.m_sz) {
            return -1;
        }
        int szread = 0;
        while (osz > 0 && (rsz = this.m_sz - this.m_off) > 0) {
            int bsz;
            byte[] buf = this.m_data[this.m_bufix];
            if (this.m_bufoff >= buf.length) {
                ++this.m_bufix;
                buf = this.m_data[this.m_bufix];
                this.m_bufoff = 0;
            }
            if (rsz > (bsz = buf.length - this.m_bufoff)) {
                rsz = bsz;
            }
            if (rsz > osz) {
                rsz = osz;
            }
            System.arraycopy(buf, this.m_bufoff, odata, ooff, rsz);
            this.m_bufoff += rsz;
            osz -= rsz;
            ooff += rsz;
            this.m_off += rsz;
            szread += rsz;
        }
        return szread;
    }
}

