/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class ByteBufferOutputStream
extends OutputStream {
    private int m_bufsz;
    private int m_sz;
    private int m_boff = Integer.MAX_VALUE;
    private byte[] m_buf;
    private List<byte[]> m_al = new ArrayList<byte[]>(16);
    private byte[][] m_bar;

    public ByteBufferOutputStream() {
        this.m_bufsz = 8192;
    }

    public ByteBufferOutputStream(int bufsz) {
        this.m_bufsz = bufsz;
        if (this.m_bufsz <= 0) {
            throw new IllegalArgumentException("bufsz <= 0: " + bufsz);
        }
    }

    @Override
    public void write(byte[] odata, int ooff, int osz) throws IOException {
        while (osz > 0) {
            int wsz;
            if (this.m_boff >= this.m_bufsz) {
                if (this.m_buf != null) {
                    this.m_al.add(this.m_buf);
                }
                this.m_buf = new byte[this.m_bufsz];
                this.m_boff = 0;
            }
            if ((wsz = this.m_bufsz - this.m_boff) > osz) {
                wsz = osz;
            }
            System.arraycopy(odata, ooff, this.m_buf, this.m_boff, wsz);
            ooff += wsz;
            osz -= wsz;
            this.m_boff += wsz;
            this.m_sz += wsz;
        }
    }

    @Override
    public void write(byte[] parm1) throws IOException {
        this.write(parm1, 0, parm1.length);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_boff >= this.m_bufsz) {
            if (this.m_buf != null) {
                this.m_al.add(this.m_buf);
            }
            this.m_buf = new byte[this.m_bufsz];
            this.m_boff = 0;
        }
        this.m_buf[this.m_boff++] = (byte)b;
        ++this.m_sz;
    }

    @Override
    public void close() throws IOException {
        if (this.m_bar != null) {
            return;
        }
        if (this.m_buf != null) {
            if (this.m_boff >= this.m_bufsz) {
                this.m_al.add(this.m_buf);
            } else {
                byte[] nbuf = new byte[this.m_boff];
                System.arraycopy(this.m_buf, 0, nbuf, 0, this.m_boff);
                this.m_al.add(nbuf);
            }
            this.m_buf = null;
        }
        this.m_bar = (byte[][])this.m_al.toArray((T[])new byte[this.m_al.size()][]);
        this.m_al = null;
    }

    public byte[][] getBuffers() {
        return this.m_bar;
    }

    public int getSize() {
        return this.m_sz;
    }
}

