/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;

public class CharReader
extends Reader {
    private final char[] m_data;
    private int m_soff;
    private int m_eoff;

    public CharReader(@Nonnull char[] data) {
        this.m_data = data;
        this.m_soff = 0;
        this.m_eoff = data.length;
    }

    public CharReader(@Nonnull char[] data, int soff, int eoff) {
        this.m_data = data;
        this.m_soff = soff;
        this.m_eoff = eoff;
    }

    @Override
    public int read() throws IOException {
        if (this.m_soff >= this.m_eoff) {
            return -1;
        }
        return this.m_data[this.m_soff++] & 0xFFFF;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int rlen = this.m_eoff - this.m_soff;
        if (rlen <= 0) {
            return -1;
        }
        if (rlen > len) {
            rlen = len;
        }
        System.arraycopy(this.m_data, this.m_soff, cbuf, off, rlen);
        this.m_soff += rlen;
        return rlen;
    }

    @Override
    public void close() throws IOException {
    }
}

