/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import to.etc.util.PropertyInfo;

@Immutable
public final class ClassInfo {
    private Class<?> m_theClass;
    private List<PropertyInfo> m_properties;
    private static final Comparator<Object> C_COMP = new Comparator<Object>(){

        @Override
        public int compare(Object a, Object b) {
            if (a instanceof PropertyInfo) {
                return ((PropertyInfo)a).getName().compareTo((String)b);
            }
            return ((PropertyInfo)b).getName().compareTo((String)a);
        }
    };

    public ClassInfo(Class<?> theClass, List<PropertyInfo> prop) {
        this.m_theClass = theClass;
        Collections.sort(prop, new Comparator<PropertyInfo>(){

            @Override
            public int compare(PropertyInfo a, PropertyInfo b) {
                return a.getName().compareTo(b.getName());
            }
        });
        this.m_properties = Collections.unmodifiableList(prop);
    }

    public Class<?> getTheClass() {
        return this.m_theClass;
    }

    public List<PropertyInfo> getProperties() {
        return this.m_properties;
    }

    public PropertyInfo findProperty(String name) {
        int ix = Collections.binarySearch(this.m_properties, name, C_COMP);
        if (ix < 0) {
            return null;
        }
        return this.m_properties.get(ix);
    }
}

