/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.ClassInfo;
import to.etc.util.PropertyInfo;

public final class ClassUtil {
    private static final Map<Class<?>, ClassInfo> m_classMap = new HashMap();

    private ClassUtil() {
    }

    @Nullable
    public static Object callMethod(@Nonnull Object on, @Nonnull String name, Object ... param) throws Exception {
        Method m = ClassUtil.findMethod(on.getClass(), name, param);
        if (m == null) {
            throw new NoSuchMethodException("A suitable method " + name + " cannot be found");
        }
        try {
            return m.invoke(on, param);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof Exception) {
                throw (Exception)itx.getCause();
            }
            throw itx;
        }
    }

    @Nullable
    public static Object callMethod(@Nonnull Object on, @Nonnull String name, @Nonnull Class[] formals, Object ... instances) throws Exception {
        Method m = ClassUtil.findMethod(on.getClass(), name, formals);
        if (m == null) {
            throw new NoSuchMethodException("A suitable method " + name + " cannot be found");
        }
        try {
            return m.invoke(on, instances);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof Exception) {
                throw (Exception)itx.getCause();
            }
            throw itx;
        }
    }

    @Nullable
    public static Method findMethod(@Nonnull Class<?> clz, @Nonnull String name, Class<?> ... param) {
        try {
            return clz.getMethod(name, param);
        }
        catch (Exception exception) {
            try {
                return clz.getDeclaredMethod(name, param);
            }
            catch (Exception x) {
                return null;
            }
        }
    }

    @Nullable
    public static Method findMethod(@Nonnull Class<?> clz, @Nonnull String name, Object ... param) {
        boolean hard = false;
        Class[] par = new Class[param.length];
        int i = param.length;
        while (--i >= 0) {
            Object v = param[i];
            if (v == null) {
                hard = true;
                par[i] = null;
                continue;
            }
            par[i] = v.getClass();
        }
        if (!hard) {
            return ClassUtil.findMethod(clz, name, par);
        }
        Method[] mar = clz.getMethods();
        Method res = null;
        for (Method m : mar) {
            Class<?>[] far;
            if (!m.getName().equals(name) || (far = m.getParameterTypes()).length != par.length) continue;
            boolean ok = true;
            int j = far.length;
            while (--j >= 0) {
                if (far[j].isAssignableFrom(par[j])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            if (res != null) {
                throw new IllegalStateException("Ambiguous method to call: " + res + " or " + m);
            }
            res = m;
        }
        return res;
    }

    @Nonnull
    public static synchronized ClassInfo getClassInfo(@Nonnull Class<?> clz) {
        ClassInfo ci = m_classMap.get(clz);
        if (ci == null) {
            List<PropertyInfo> proplist = ClassUtil.calculateProperties(clz);
            ci = new ClassInfo(clz, proplist);
            m_classMap.put(clz, ci);
        }
        return ci;
    }

    @Nullable
    public static PropertyInfo findPropertyInfo(@Nonnull Class<?> clz, @Nonnull String property) {
        return ClassUtil.getClassInfo(clz).findProperty(property);
    }

    @Nonnull
    public static List<PropertyInfo> getProperties(@Nonnull Class<?> cl) {
        ClassInfo ci = ClassUtil.getClassInfo(cl);
        return ci.getProperties();
    }

    @Nonnull
    public static List<PropertyInfo> calculateProperties(@Nonnull Class<?> cl) {
        HashMap<String, Info> map = new HashMap<String, Info>();
        StringBuilder sb = new StringBuilder(40);
        for (Method m : cl.getMethods()) {
            int mod = m.getModifiers();
            if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
            String name = m.getName();
            boolean setter = false;
            sb.setLength(0);
            if (name.startsWith("get")) {
                sb.append(name, 3, name.length());
            } else if (name.startsWith("is")) {
                sb.append(name, 2, name.length());
            } else {
                if (!name.startsWith("set")) continue;
                sb.append(name, 3, name.length());
                setter = true;
            }
            if (sb.length() == 0) continue;
            Class<?>[] param = m.getParameterTypes();
            if (!setter ? param.length != 0 : param.length != 1) continue;
            if (sb.length() == 1) {
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            } else if (!Character.isUpperCase(sb.charAt(1))) {
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
            }
            name = sb.toString();
            Info i = (Info)map.get(name);
            if (i == null) {
                i = new Info();
                map.put(name, i);
            }
            if (setter) {
                i.setterList.add(m);
                continue;
            }
            if (i.getter == null) {
                i.getter = m;
                continue;
            }
            if (!i.getter.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            i.getter = m;
        }
        ArrayList<PropertyInfo> res = new ArrayList<PropertyInfo>();
        for (String name : map.keySet()) {
            Info i = (Info)map.get(name);
            if (i.getter == null) continue;
            Method setter = null;
            for (Method m : i.setterList) {
                if (m.getParameterTypes()[0] != i.getter.getReturnType()) continue;
                setter = m;
                break;
            }
            res.add(new PropertyInfo(name, i.getter, setter));
        }
        return res;
    }

    @Nonnull
    public static String getMethodName(@Nonnull String prefix, @Nonnull String property) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        if (property.length() > 0) {
            sb.append(Character.toUpperCase(property.charAt(0)));
            sb.append(property, 1, property.length());
        }
        return sb.toString();
    }

    @Nullable
    public static Object callObjectMethod(@Nonnull Object src, @Nonnull String name, @Nonnull Class<?>[] types, Object ... parameters) throws SQLException {
        try {
            Method m = src.getClass().getMethod(name, types);
            return m.invoke(src, parameters);
        }
        catch (InvocationTargetException itx) {
            if (itx.getCause() instanceof SQLException) {
                throw (SQLException)itx.getCause();
            }
            throw new RuntimeException(itx.getCause().toString(), itx.getCause());
        }
        catch (Exception x) {
            throw new RuntimeException("Exception calling " + name + " on " + src + ": " + x, x);
        }
    }

    public static final Class<?> loadClass(ClassLoader cl, String cname) {
        try {
            return cl.loadClass(cname);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    public static final <T> T loadInstance(@Nonnull ClassLoader cl, @Nonnull Class<T> clz, @Nonnull String className) throws Exception {
        Class<?> acl;
        try {
            acl = cl.loadClass(className);
        }
        catch (Exception x) {
            throw new RuntimeException("The class " + className + " cannot be found/loaded: " + x);
        }
        if (!clz.isAssignableFrom(acl)) {
            throw new IllegalArgumentException("The class " + className + " is not a/does not implement " + clz.getName());
        }
        try {
            return (T)acl.newInstance();
        }
        catch (Exception x) {
            throw new RuntimeException("Cannot instantiate " + acl + ": " + x);
        }
    }

    @Nullable
    public static <T extends Annotation> T findAnnotation(@Nonnull Annotation[] ar, @Nonnull Class<T> clz) {
        for (Annotation a : ar) {
            if (a.annotationType() != clz) continue;
            return (T)a;
        }
        return null;
    }

    public static void propertyNameToJava(@Nonnull StringBuilder sb, @Nonnull String in) {
        if (in.length() == 0) {
            return;
        }
        int len = sb.length();
        sb.append(in);
        sb.setCharAt(len, Character.toUpperCase(sb.charAt(len)));
    }

    @Nonnull
    public static String propertyNameToJava(@Nonnull String in) {
        StringBuilder sb = new StringBuilder();
        ClassUtil.propertyNameToJava(sb, in);
        return sb.toString();
    }

    @Nullable
    public static Class<?> findCollectionType(@Nonnull Type genericType) {
        Type[] tar;
        Class cl;
        ParameterizedType pt;
        Type raw;
        Class cl2;
        if (genericType instanceof Class && (cl2 = (Class)genericType).isArray()) {
            return cl2.getComponentType();
        }
        if (genericType instanceof ParameterizedType && (raw = (pt = (ParameterizedType)genericType).getRawType()) instanceof Class && Collection.class.isAssignableFrom(cl = (Class)raw) && (tar = pt.getActualTypeArguments()) != null && tar.length == 1) {
            return (Class)tar[0];
        }
        return null;
    }

    public static boolean isCollectionOrArrayType(@Nonnull Class<?> clz) {
        return clz.isArray() || Collection.class.isAssignableFrom(clz);
    }

    @Nonnull
    public static List<Class<?>> getClassHierarchy(@Nonnull Class<?> clzin) {
        ArrayList res = new ArrayList();
        ClassUtil.appendClassHierarchy(res, clzin);
        return res;
    }

    public static void appendClassHierarchy(@Nonnull List<Class<?>> res, @Nonnull Class<?> clzin) {
        Class<?>[] ifar;
        if (res.contains(clzin)) {
            return;
        }
        Class<?> sclz = clzin.getSuperclass();
        if (null != sclz) {
            ClassUtil.appendClassHierarchy(res, sclz);
        }
        for (Class<?> iclz : ifar = clzin.getInterfaces()) {
            ClassUtil.appendClassHierarchy(res, iclz);
        }
        if (res.contains(clzin)) {
            return;
        }
        res.add(clzin);
    }

    @Nonnull
    public static URL[] findUrlsFor(@Nonnull ClassLoader loader) {
        ArrayList<URL> res = new ArrayList<URL>();
        ClassUtil.findUrlsFor(res, loader);
        return res.toArray(new URL[res.size()]);
    }

    private static void findUrlsFor(@Nonnull List<URL> result, @Nullable ClassLoader loader) {
        ClassLoader parent;
        if (loader == null) {
            return;
        }
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            for (URL u : ucl.getURLs()) {
                result.add(u);
            }
        }
        if (null != (parent = loader.getParent())) {
            ClassUtil.findUrlsFor(result, parent);
        }
    }

    @Nullable
    public static <T> Constructor<T> findConstructor(@Nonnull Class<T> clz, Class<?> ... formals) {
        try {
            return clz.getConstructor(formals);
        }
        catch (Exception x) {
            return null;
        }
    }

    public static <T> T callConstructor(Class<T> clz, Class<?>[] formals, Object ... args) throws Exception {
        Constructor<T> c = ClassUtil.findConstructor(clz, formals);
        if (c == null) {
            throw new IllegalStateException("Cannot find constructor in " + clz + " with args " + Arrays.toString(formals));
        }
        return c.newInstance(args);
    }

    @Nullable
    public static File findSrcForModification(@Nonnull String className) throws Exception {
        String rel;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(rel = className.replace(".", "/") + ".class");
        if (resource == null) {
            return null;
        }
        String path = resource.getFile();
        if (resource.getProtocol().equals("jar")) {
            throw new Exception("Finding sources in jars for modifications is not supported.");
        }
        String srcRel = rel.substring(0, rel.length() - 5) + "java";
        File root = new File(path.substring(0, path.length() - rel.length()));
        File[] files = new File[1];
        ClassUtil.find(root.getParentFile(), srcRel, files);
        return files[0];
    }

    @Nullable
    public static File findSrcFolderForModification(@Nonnull String packageName) throws Exception {
        String rel;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL resource = classLoader.getResource(rel = packageName.replace(".", "/"));
        if (resource == null) {
            return null;
        }
        String path = resource.getFile();
        if (resource.getProtocol().equals("jar")) {
            throw new Exception("Finding sources in jars for modifications is not supported.");
        }
        File root = new File(path.substring(0, path.length() - rel.length()));
        File[] files = new File[1];
        ClassUtil.find(root.getParentFile(), rel, files);
        return files[0];
    }

    private static void find(@Nullable File root, @Nonnull String srcRel, @Nonnull File[] files) {
        if (root == null) {
            return;
        }
        File[] listFiles = root.listFiles();
        if (listFiles != null) {
            for (int i = 0; i < listFiles.length; ++i) {
                File child = listFiles[i];
                File src = new File(child, srcRel);
                if (!src.exists()) continue;
                files[0] = src;
                return;
            }
        }
        ClassUtil.find(root.getParentFile(), srcRel, files);
    }

    public static final Object getClassValue(@Nonnull Object inst, @Nonnull String name) throws Exception {
        Method m;
        if (inst == null) {
            throw new IllegalStateException("The input object is null");
        }
        Class<?> clz = inst.getClass();
        try {
            m = clz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalStateException("Unknown method '" + name + "()' on class=" + clz);
        }
        try {
            return m.invoke(inst, new Object[0]);
        }
        catch (IllegalAccessException iax) {
            throw new IllegalStateException("Cannot call method '" + name + "()' on class=" + clz + ": " + iax);
        }
        catch (InvocationTargetException itx) {
            Throwable c = itx.getCause();
            if (c instanceof Exception) {
                throw (Exception)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw itx;
        }
    }

    @Nullable
    public static <T extends Annotation> T findAnnotationIncludingSuperClasses(@Nonnull Method annotatedMethod, @Nonnull Class<T> annotationType) {
        T annotation = annotatedMethod.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        Class<?> parent = annotatedMethod.getDeclaringClass().getSuperclass();
        if (parent != null) {
            try {
                Method superMethod = parent.getDeclaredMethod(annotatedMethod.getName(), new Class[0]);
                if (superMethod != null) {
                    return ClassUtil.findAnnotationIncludingSuperClasses(superMethod, annotationType);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    private static class Info {
        public Method getter;
        public List<Method> setterList = new ArrayList<Method>();
    }
}

