/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import to.etc.util.ClassUtil;
import to.etc.util.PropertyInfo;

public class ClassUtilCached {
    private static final ClassUtilCached m_instance = new ClassUtilCached();
    private Map<Class<?>, Reference<ClassInfo>> m_classMap = new HashMap();

    @Nonnull
    public static ClassUtilCached getInstance() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ClassInfo getClassInfo(@Nonnull Class<?> clz) {
        ClassInfo ci = null;
        Map<Class<?>, Reference<ClassInfo>> map = this.m_classMap;
        synchronized (map) {
            Reference<ClassInfo> rci = this.m_classMap.get(clz);
            if (null != rci) {
                ci = rci.get();
            }
            if (null == ci) {
                ci = new ClassInfo(clz);
                this.m_classMap.put(clz, new WeakReference<ClassInfo>(ci));
            }
        }
        ci.initialize();
        return ci;
    }

    @Nonnull
    public List<PropertyInfo> getProperties(Class<?> clz) {
        return this.getClassInfo(clz).getPropertyList();
    }

    @Nullable
    public PropertyInfo findProperty(Class<?> clz, String name) {
        return this.getClassInfo(clz).findProperty(name);
    }

    @Immutable
    public static class ClassInfo {
        @Nonnull
        private Class<?> m_theClass;
        private Map<String, PropertyInfo> m_propertyMap;
        private List<PropertyInfo> m_propertyList;

        ClassInfo(@Nonnull Class<?> theClass) {
            this.m_theClass = theClass;
        }

        synchronized void initialize() {
            if (null != this.m_propertyList) {
                return;
            }
            List<PropertyInfo> plist = ClassUtil.getProperties(this.m_theClass);
            this.m_propertyList = Collections.unmodifiableList(plist);
            HashMap<String, PropertyInfo> pmap = new HashMap<String, PropertyInfo>();
            for (PropertyInfo pi : plist) {
                pmap.put(pi.getName(), pi);
            }
            this.m_propertyMap = Collections.unmodifiableMap(pmap);
        }

        @Nonnull
        public List<PropertyInfo> getPropertyList() {
            return this.m_propertyList;
        }

        @Nonnull
        public Map<String, PropertyInfo> getPropertyMap() {
            return this.m_propertyMap;
        }

        @Nullable
        public PropertyInfo findProperty(String name) {
            return this.m_propertyMap.get(name);
        }
    }
}

