/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.util.List;
import java.util.Map;
import to.etc.util.ConfigSource;
import to.etc.util.FileTool;
import to.etc.util.PropData;
import to.etc.util.PropReader;
import to.etc.util.PropWriter;
import to.etc.util.StringTool;

@Deprecated
public class ConfigFile
implements ConfigSource {
    private List<PropData> m_v;
    private Map<String, PropData> m_ht;
    private long m_read_ts;
    private int m_reread_s;
    private File m_path;
    private long m_cts;
    private ConfigFile m_default_cf;

    public ConfigFile() {
    }

    public ConfigFile(ConfigFile default_cf) {
        this.m_default_cf = default_cf;
    }

    public ConfigFile(File cf) throws Exception {
        this.setFile(cf);
    }

    public ConfigFile(File f, File localf) throws Exception {
        if (localf != null && localf.exists()) {
            this.m_default_cf = new ConfigFile(f);
            this.setFile(localf);
        } else {
            this.setFile(f);
        }
    }

    public synchronized void setFile(File f) throws Exception {
        if (!(f.exists() && f.isFile() && f.canRead())) {
            throw new Exception(f + ": not accessible.");
        }
        this.m_path = f;
        this.m_read_ts = 0L;
    }

    public void setSearchFile(String fin) throws Exception {
        File f;
        String fn;
        int pos = FileTool.findFilenameExtension(fin);
        String envname = fin;
        if (pos != -1) {
            envname = fin.substring(0, pos);
        }
        if ((fn = System.getProperty(envname.toUpperCase())) != null) {
            File f2 = new File(fn);
            if (f2.exists()) {
                this.setFile(f2);
            }
            throw new Exception("Environment variable " + fin + " points to inaccessible file " + fn);
        }
        String ext = FileTool.getFileExtension(fin);
        if (ext.length() == 0) {
            fin = fin + ".properties";
        }
        if ((f = new File(fin)).exists() && f.canRead()) {
            this.setFile(f);
            return;
        }
        File path = StringTool.findFileOnEnv(fin, "java.class.path");
        if (path == null) {
            throw new Exception("\nLoad config: Cannot locate " + fin);
        }
        this.setFile(path);
    }

    @Override
    public ConfigSource getSubSource(String key) {
        return new SubSource(this, key);
    }

    public File getFile() {
        return this.m_path;
    }

    public String toString() {
        return this.m_path == null ? "undefined file" : this.m_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        this.m_cts = 0L;
        ConfigFile configFile = this;
        synchronized (configFile) {
            if (this.m_read_ts != 0L) {
                if (this.m_reread_s == 0) {
                    return;
                }
                this.m_cts = System.currentTimeMillis();
                if (this.m_cts < (long)this.m_reread_s + this.m_read_ts) {
                    return;
                }
            }
        }
        PropReader pr = new PropReader();
        pr.readFile(this.m_path);
        ConfigFile configFile2 = this;
        synchronized (configFile2) {
            this.m_ht = pr.m_ht;
            this.m_v = pr.m_v;
            this.m_read_ts = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProp(String name, String defval) throws Exception {
        this.init();
        ConfigFile configFile = this;
        synchronized (configFile) {
            PropData pd = this.m_ht.get(name);
            if (pd == null) {
                if (this.m_default_cf == null) {
                    return defval;
                }
                return this.m_default_cf.getProp(name, defval);
            }
            return pd.m_val;
        }
    }

    public int getProp(String name, int defval) throws Exception {
        String sv = this.getProp(name, null);
        if (sv == null) {
            return defval;
        }
        try {
            return Integer.parseInt(sv);
        }
        catch (Exception ex) {
            throw new Exception(this.m_path + ": propery " + name + " must be numeric");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProp(String key, String val, String comment) throws Exception {
        this.init();
        ConfigFile configFile = this;
        synchronized (configFile) {
            PropData pd = this.m_ht.get(key.toLowerCase());
            if (pd == null) {
                pd = new PropData();
                pd.m_key = key;
                pd.m_blankLines = 1;
                this.m_v.add(pd);
                this.m_ht.put(key.toLowerCase(), pd);
            }
            pd.m_val = val;
            pd.m_cmt = comment;
            PropWriter pw = new PropWriter();
            pw.init(this.m_path, this.m_ht, this.m_v);
            pw.writePropFile();
        }
    }

    public void setProp(String key, int val, String comment) throws Exception {
        this.setProp(key, Integer.toString(val), comment);
    }

    @Override
    public String getOption(String key) throws Exception {
        return this.getProp(key, null);
    }

    @Override
    public Object getSourceObject() {
        return this.m_path;
    }

    private static class SubSource
    implements ConfigSource {
        private String m_key;
        private ConfigSource m_cs;

        public SubSource(ConfigSource cs, String key) {
            this.m_key = key;
            this.m_cs = cs;
        }

        @Override
        public String getOption(String key) throws Exception {
            return this.m_cs.getOption(this.m_key + "." + key);
        }

        @Override
        public Object getSourceObject() {
            return this.m_cs.getSourceObject() + " -> " + this.m_key;
        }

        @Override
        public ConfigSource getSubSource(String key) throws Exception {
            return new SubSource(this, key);
        }
    }
}

