/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.GregorianCalendarFixDutchTime;
import to.etc.util.StringTool;

public final class DateUtil {
    @Nonnull
    private static final ThreadLocal<Calendar> m_testDate = new ThreadLocal();
    @Nullable
    private static Calendar m_systemTestDate;
    @Nonnull
    public static final java.util.Date FUTURE;
    private static final long SECS = 1000L;
    private static final long MINS = 60000L;
    private static final long HOURS = 3600000L;
    private static final long DAYS = 86400000L;
    public static final Comparator<Calendar> CALENDAR_TIMES_COMPARATOR;

    private DateUtil() {
    }

    public static long getTime(@Nonnull java.util.Date from, @Nonnull TimeUnit unit) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(from);
        int hours = instance.get(11);
        int mins = instance.get(12) + 60 * hours;
        int secs = instance.get(13) + 60 * mins;
        long millis = instance.get(14) + 1000 * secs;
        return unit.convert(millis, TimeUnit.MILLISECONDS);
    }

    @Nonnull
    public static java.util.Date truncateCeil(@Nonnull java.util.Date date) {
        long time = DateUtil.getTime(date, TimeUnit.SECONDS);
        if (time == 0L) {
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateUtil.clearTime(cal);
        cal.add(5, 1);
        return cal.getTime();
    }

    public static boolean isWeekend(@Nonnull Calendar cal) {
        int day = cal.get(7);
        return day == 1 || day == 7;
    }

    public static java.util.Date dateFromDateTime(java.util.Date coredate, String timestring) {
        if (coredate == null) {
            return null;
        }
        if (timestring == null) {
            return coredate;
        }
        if ((timestring = timestring.trim()).length() == 0) {
            return coredate;
        }
        int pos = timestring.indexOf(58);
        int hour = 0;
        int ix = 0;
        if (pos == -1) {
            return coredate;
        }
        while (ix < pos) {
            char c;
            if (!Character.isDigit(c = timestring.charAt(ix++))) {
                return coredate;
            }
            hour = hour * 10 + (c - 48);
        }
        int len = timestring.length();
        ix = pos + 1;
        int end = (pos = timestring.indexOf(58, ix)) == -1 ? len : pos;
        int minutes = 0;
        while (ix < end) {
            char c;
            if (!Character.isDigit(c = timestring.charAt(ix++))) {
                return coredate;
            }
            minutes = minutes * 10 + (c - 48);
        }
        int seconds = 0;
        if (pos != -1) {
            end = len;
            ix = pos + 1;
            while (ix < len) {
                char c;
                if (!Character.isDigit(c = timestring.charAt(ix++))) {
                    return coredate;
                }
                seconds = seconds * 10 + (c - 48);
            }
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(coredate);
        cal.set(11, hour);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 0);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static String encodeTimeInMS(long millis, int nfields, boolean shortest) {
        long h = (millis %= 86400000L) / 3600000L;
        long m = (millis %= 3600000L) / 60000L;
        long s = (millis %= 60000L) / 1000L;
        millis %= 1000L;
        String hs = Long.toString(h);
        if (nfields <= 1 || shortest && m == 0L && nfields == 2 || shortest && m == 0L && s == 0L && nfields == 3) {
            return hs;
        }
        StringBuilder sb = new StringBuilder(10);
        sb.append(h);
        sb.append(':');
        if (m < 10L) {
            sb.append('0');
        }
        sb.append(m);
        if (nfields <= 2 || shortest && s == 0L) {
            return sb.toString();
        }
        sb.append(':');
        if (s < 10L) {
            sb.append('0');
        }
        sb.append(s);
        return sb.toString();
    }

    public static long decodeTime(String timestring) {
        if (timestring == null) {
            return -1L;
        }
        int len = (timestring = timestring.trim()).length();
        if (len < 5) {
            return -1L;
        }
        int pos = timestring.indexOf(58);
        if (pos == -1) {
            return -1L;
        }
        int hour = 0;
        int ix = 0;
        while (ix < pos) {
            char c;
            if (!Character.isDigit(c = timestring.charAt(ix++))) {
                return -1L;
            }
            hour = hour * 10 + (c - 48);
        }
        ix = pos + 1;
        int end = (pos = timestring.indexOf(58, ix)) == -1 ? len : pos;
        int minutes = 0;
        while (ix < end) {
            char c;
            if (!Character.isDigit(c = timestring.charAt(ix++))) {
                return -1L;
            }
            minutes = minutes * 10 + (c - 48);
        }
        int seconds = 0;
        if (pos != -1) {
            end = len;
            ix = pos + 1;
            while (ix < len) {
                char c;
                if (!Character.isDigit(c = timestring.charAt(ix++))) {
                    return -1L;
                }
                seconds = seconds * 10 + (c - 48);
            }
        }
        return (long)hour * 60L * 60L * 1000L + (long)minutes * 60L * 1000L + (long)seconds * 1000L;
    }

    public static String extractTimeString(java.util.Date dt, int size) {
        if (size != 5 && size != 8) {
            throw new IllegalStateException("Accepts only 5 or 8 char times.");
        }
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        if (cal.get(11) == 0 && cal.get(12) == 0) {
            return null;
        }
        char[] b = new char[size];
        int v = cal.get(11);
        b[0] = (char)(v / 10 + 48);
        b[1] = (char)(v % 10 + 48);
        b[2] = 58;
        v = cal.get(12);
        b[3] = (char)(v / 10 + 48);
        b[4] = (char)(v % 10 + 48);
        if (size > 5) {
            b[5] = 58;
            v = cal.get(13);
            b[6] = (char)(v / 10 + 48);
            b[7] = (char)(v % 10 + 48);
        }
        return new String(b);
    }

    public static java.util.Date truncateDate(java.util.Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        DateUtil.clearTime(cal);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date truncateSeconds(java.util.Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date incrementDate(java.util.Date dt, int field, int amount) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.add(field, amount);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static void truncateDate(java.util.Date dest, java.util.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        DateUtil.clearTime(cal);
        dest.setTime(cal.getTimeInMillis());
    }

    public static java.util.Date tomorrow(java.util.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        DateUtil.clearTime(cal);
        cal.add(5, 1);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date dumbEndOfDayDate(java.util.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static void clearTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static java.util.Date yearStartDate(int year) {
        Calendar cal = Calendar.getInstance();
        DateUtil.clearTime(cal);
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date calculateDurationEndInSec(java.util.Date start, int durationInSeconds) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(13, durationInSeconds);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date dateFor(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        DateUtil.clearTime(cal);
        return cal.getTime();
    }

    public static void setDate(Calendar cal, int year, int month, int day) {
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
    }

    public static java.util.Date dateFor(int year, int month, int day, int hour, int minute, int sec, int mils) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        DateUtil.setTime(cal, hour, minute, sec, mils);
        return cal.getTime();
    }

    public static void setTime(Calendar cal, int h, int m, int s, int ms) {
        cal.set(11, h);
        cal.set(12, m);
        cal.set(13, s);
        cal.set(14, ms);
    }

    public static java.util.Date addMinutes(java.util.Date in, int minutes) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.add(12, minutes);
        return new java.util.Date(cal.getTimeInMillis());
    }

    @Nonnull
    public static java.util.Date addDays(@Nonnull java.util.Date in, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.add(6, days);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date addMonths(java.util.Date in, int months) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.add(2, months);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static java.util.Date addYears(java.util.Date in, int years) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.add(1, years);
        return new java.util.Date(cal.getTimeInMillis());
    }

    public static boolean between(java.util.Date start, java.util.Date end, java.util.Date v) {
        return !(start != null && v.getTime() < start.getTime() || end != null && v.getTime() >= end.getTime());
    }

    public static boolean overlaps(java.util.Date s1, java.util.Date e1, java.util.Date s2, java.util.Date e2) {
        return s1.getTime() < e2.getTime() && s2.getTime() < e1.getTime();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:40:21"), 3, true));
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:40:21"), 2, true));
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:40:21"), 1, true));
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:00:00"), 3, true));
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:10:00"), 3, true));
        System.out.println(DateUtil.encodeTimeInMS(DateUtil.decodeTime("13:00:20"), 3, true));
    }

    public static java.util.Date setDateOnly(java.util.Date finisheddate, java.util.Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        if (finisheddate == null) {
            cal.set(0, 0, 0, 0, 0);
        } else {
            cal.setTime(finisheddate);
        }
        int hr = cal.get(11);
        int mn = cal.get(12);
        int sc = cal.get(13);
        int ms = cal.get(14);
        cal.setTime(dt);
        cal.set(11, hr);
        cal.set(12, mn);
        cal.set(13, sc);
        cal.set(14, ms);
        return cal.getTime();
    }

    public static java.util.Date getFirstDayOfNextMonth(java.util.Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(2, cal.get(2) + 1);
        cal.set(5, 1);
        return cal.getTime();
    }

    private static Calendar createIsoCalendar() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.clear();
        cal.setMinimalDaysInFirstWeek(4);
        cal.setFirstDayOfWeek(2);
        return cal;
    }

    public static int deltaMonths(java.util.Date start, java.util.Date end) {
        Calendar a = Calendar.getInstance();
        a.setTime(start);
        int sm = a.get(1) * 12 + a.get(2);
        a.setTime(end);
        int em = a.get(1) * 12 + a.get(2);
        return em - sm;
    }

    public static int deltaInDays(java.util.Date start, java.util.Date end) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(start);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(end);
        DateUtil.clearTime(startCal);
        DateUtil.clearTime(endCal);
        long endL = endCal.getTimeInMillis() + (long)endCal.getTimeZone().getOffset(endCal.getTimeInMillis());
        long startL = startCal.getTimeInMillis() + (long)startCal.getTimeZone().getOffset(startCal.getTimeInMillis());
        return (int)((double)(endL - startL) / 8.64E7);
    }

    public static Calendar getIsoCalendarForYearAndWeek(int year, int weekOfYear) {
        Calendar cal = DateUtil.createIsoCalendar();
        cal.set(1, year);
        cal.set(3, weekOfYear);
        return cal;
    }

    @Nonnull
    public static java.util.Date convertToDate(@Nonnull String input, @Nonnull String dateFormat, boolean lenient) throws ParseException {
        if (StringTool.isBlank(dateFormat)) {
            throw new IllegalArgumentException("dateFormat must not be empty");
        }
        if (StringTool.isBlank(input)) {
            throw new IllegalArgumentException("input string must not be empty");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        simpleDateFormat.setLenient(lenient);
        return simpleDateFormat.parse(input);
    }

    @Nonnull
    public static java.util.Date convertToDate(@Nonnull String input, @Nonnull String dateFormat) throws ParseException {
        return DateUtil.convertToDate(input, dateFormat, true);
    }

    public static int getYear(@Nonnull java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(@Nonnull java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static java.util.Date sqlToUtilDate(@Nullable Date sqlDate) {
        if (null == sqlDate) {
            return null;
        }
        return new java.util.Date(sqlDate.getTime());
    }

    @Nonnull
    public static String formatSafe(@Nullable java.util.Date date, @Nonnull DateFormat format) {
        if (null == date) {
            return "";
        }
        return format.format(date);
    }

    @Nonnull
    public static synchronized java.util.Date now() {
        Calendar now = m_testDate.get();
        if (null == now) {
            if (null == m_systemTestDate) {
                return new java.util.Date();
            }
            now = m_systemTestDate;
        }
        Calendar cal = Calendar.getInstance();
        DateUtil.setDate(cal, now.get(1), now.get(2), now.get(5));
        return cal.getTime();
    }

    public static void setTestDate(@Nullable java.util.Date now) {
        if (null == now) {
            m_testDate.set(null);
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        DateUtil.clearTime(cal);
        m_testDate.set(cal);
    }

    public static boolean isTestDateSet() {
        return null != m_testDate.get() || null != m_systemTestDate;
    }

    public static synchronized void setSystemTestDate(@Nullable java.util.Date now) {
        if (null == now) {
            m_systemTestDate = null;
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        DateUtil.clearTime(cal);
        m_systemTestDate = cal;
    }

    @Nonnull
    public static Calendar getCalendar() {
        TimeZone zone = TimeZone.getDefault();
        String id = zone.getID();
        if (id.equals("Europe/Amsterdam")) {
            return new GregorianCalendarFixDutchTime(zone, Locale.getDefault(Locale.Category.FORMAT));
        }
        return new GregorianCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    @Nonnull
    public static Calendar getCalendar(@Nonnull Locale aLocale) {
        return new GregorianCalendarFixDutchTime(aLocale);
    }

    public static boolean isFutureIndeterminate(@Nullable java.util.Date date) {
        if (null == date) {
            return false;
        }
        return date.getYear() >= 1099;
    }

    static {
        FUTURE = DateUtil.dateFor(9999, 11, 31);
        CALENDAR_TIMES_COMPARATOR = new Comparator<Calendar>(){

            @Override
            public int compare(Calendar first, Calendar second) {
                if (first.get(11) < second.get(11)) {
                    return -1;
                }
                if (first.get(11) == second.get(11)) {
                    if (first.get(12) < second.get(12)) {
                        return -1;
                    }
                    if (first.get(12) == second.get(12)) {
                        if (first.get(13) < second.get(13)) {
                            return -1;
                        }
                        if (first.get(13) == second.get(13)) {
                            if (first.get(14) < second.get(14)) {
                                return -1;
                            }
                            if (first.get(14) == second.get(14)) {
                                return 0;
                            }
                        }
                    }
                }
                return 1;
            }
        };
    }
}

