/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Diff<T> {
    public static boolean DEBUG = false;
    public static boolean DEBUG2 = false;
    private final int m_startIndex;
    private final int m_endIndex;
    @Nonnull
    private final List<T> m_list;
    @Nonnull
    private final Type m_type;

    private Diff(int startIndex, int endIndex, @Nonnull List<T> list, @Nonnull Type type) {
        this.m_startIndex = startIndex;
        this.m_endIndex = endIndex;
        this.m_list = list;
        this.m_type = type;
    }

    public Type getType() {
        return this.m_type;
    }

    public int getEndIndex() {
        return this.m_endIndex;
    }

    public int getStartIndex() {
        return this.m_startIndex;
    }

    @Nonnull
    public List<T> getList() {
        return this.m_list;
    }

    public String toString() {
        char c;
        StringBuilder sb = new StringBuilder();
        switch (this.getType()) {
            default: {
                throw new IllegalStateException();
            }
            case ADD: {
                c = '+';
                break;
            }
            case DELETE: {
                c = '-';
                break;
            }
            case SAME: {
                c = ' ';
            }
        }
        sb.append(c).append(" @").append(this.m_startIndex).append(",").append(this.m_endIndex).append(" ").append("\n");
        for (T item : this.m_list) {
            sb.append(c).append(" ").append(item).append("\n");
        }
        return sb.toString();
    }

    public static <I> List<Diff<I>> diffList(@Nonnull List<I> oldl, @Nonnull List<I> newl, @Nullable Comparator<I> comparator) {
        return Diff.diffList(oldl, newl, comparator, true);
    }

    public static <I> List<Diff<I>> diffList(@Nonnull List<I> oldl, @Nonnull List<I> newl, @Nullable Comparator<I> comparator, boolean skipsame) {
        int i;
        I co;
        I so;
        int nbeg;
        if (null == comparator) {
            comparator = new Comparator<I>(){

                @Override
                public int compare(I o, I n) {
                    if (o == n) {
                        return 0;
                    }
                    if (o == null) {
                        return 1;
                    }
                    if (n == null) {
                        return -1;
                    }
                    if (o instanceof Comparable) {
                        Comparable c = (Comparable)o;
                        return c.compareTo(n);
                    }
                    return o.toString().compareTo(n.toString());
                }
            };
        }
        int oend = oldl.size();
        int nend = newl.size();
        int obeg = 0;
        for (nbeg = 0; obeg < oend && nbeg < nend && 0 == comparator.compare(so = oldl.get(obeg), co = newl.get(nbeg)); ++obeg, ++nbeg) {
        }
        while (oend > obeg && nend > nbeg && 0 == comparator.compare(so = oldl.get(oend - 1), co = newl.get(nend - 1))) {
            --nend;
            --oend;
        }
        if (obeg >= oend && nbeg >= nend) {
            return Collections.EMPTY_LIST;
        }
        int m = oend - obeg + 1;
        int n = nend - nbeg + 1;
        int[][] car = new int[m][];
        for (i = 0; i < m; ++i) {
            car[i] = new int[n];
            car[i][0] = 0;
        }
        for (i = 0; i < n; ++i) {
            car[0][i] = 0;
        }
        for (i = 1; i < m; ++i) {
            for (int j = 1; j < n; ++j) {
                I co2;
                I so2 = oldl.get(obeg + i - 1);
                car[i][j] = 0 == comparator.compare(so2, co2 = newl.get(nbeg + j - 1)) ? car[i - 1][j - 1] + 1 : Math.max(car[i][j - 1], car[i - 1][j]);
            }
        }
        ArrayList<Item<I>> res = new ArrayList<Item<I>>();
        ArrayList<String> tmp = new ArrayList<String>();
        int xxx = oldl.size();
        while (--xxx >= oend) {
            Item<I> e = new Item<I>(Type.SAME, oldl.get(xxx));
            res.add(e);
            e.setIndex(xxx);
            if (!DEBUG2) continue;
            tmp.add("  " + oldl.get(xxx) + " @" + xxx + " (e)");
        }
        int i2 = m - 1;
        int j = n - 1;
        while (j > 0 || i2 > 0) {
            if (i2 > 0 && j > 0 && 0 == comparator.compare(oldl.get(obeg + i2 - 1), newl.get(nbeg + j - 1))) {
                int sindex = obeg + i2 - 1;
                if (DEBUG2) {
                    tmp.add("  " + oldl.get(sindex) + " @" + sindex);
                }
                res.add(new Item<I>(Type.SAME, oldl.get(sindex)));
                --i2;
                --j;
                continue;
            }
            if (j > 0 && (i2 == 0 || car[i2][j - 1] >= car[i2 - 1][j])) {
                int nindex = nbeg + j - 1;
                I nitem = newl.get(nindex);
                if (DEBUG2) {
                    tmp.add("+ " + nitem + " @" + nindex);
                }
                res.add(new Item<I>(Type.ADD, nitem));
                --j;
                continue;
            }
            if (i2 <= 0 || j != 0 && car[i2][j - 1] >= car[i2 - 1][j]) continue;
            int oindex = obeg + i2 - 1;
            I oitem = oldl.get(oindex);
            if (DEBUG2) {
                tmp.add("- " + oitem + " @" + oindex);
            }
            res.add(new Item<I>(Type.DELETE, oitem));
            --i2;
        }
        i2 = obeg;
        while (--i2 >= 0) {
            if (DEBUG2) {
                tmp.add("  " + oldl.get(i2) + " @" + i2 + " (s)");
            }
            res.add(new Item<I>(Type.SAME, oldl.get(i2)));
        }
        Collections.reverse(tmp);
        Collections.reverse(res);
        ArrayList<Diff<I>> dres = new ArrayList<Diff<I>>();
        int oindex = 0;
        int nindex = 0;
        int lastoindex = 0;
        int lastnindex = 0;
        Type currchange = Type.SAME;
        for (Item item : res) {
            item.setIndex(oindex);
            if (currchange != item.getType()) {
                if (currchange != Type.SAME || !skipsame) {
                    Diff.addDiffItem(oldl, newl, oindex, dres, nindex, lastoindex, lastnindex, currchange);
                }
                currchange = item.getType();
                lastoindex = oindex;
                lastnindex = nindex;
            }
            switch (item.getType()) {
                case ADD: {
                    ++nindex;
                    break;
                }
                case DELETE: {
                    ++oindex;
                    break;
                }
                case SAME: {
                    ++oindex;
                    ++nindex;
                }
            }
        }
        if (currchange != Type.SAME || !skipsame) {
            Diff.addDiffItem(oldl, newl, oindex, dres, nindex, lastoindex, lastnindex, currchange);
        }
        if (DEBUG) {
            for (Item item : res) {
                System.out.println(" " + item);
            }
        }
        if (DEBUG) {
            System.out.println("Diff: delta:");
            for (Diff diff : dres) {
                System.out.print(diff);
            }
        }
        if (DEBUG2) {
            System.out.println("Debug list:");
            for (String string : tmp) {
                System.out.println(" " + string);
            }
        }
        return dres;
    }

    private static <I> void addDiffItem(List<I> oldl, List<I> newl, int oindex, List<Diff<I>> dres, int nindex, int lastoindex, int lastnindex, Type type) {
        if (lastoindex != oindex || lastnindex != nindex) {
            switch (type) {
                case ADD: {
                    dres.add(new Diff<I>(lastoindex, oindex, newl.subList(lastnindex, nindex), Type.ADD));
                    break;
                }
                case DELETE: {
                    dres.add(new Diff<I>(lastoindex, oindex, oldl.subList(lastoindex, oindex), Type.DELETE));
                    break;
                }
                case SAME: {
                    dres.add(new Diff<I>(lastoindex, oindex, oldl.subList(lastoindex, oindex), Type.SAME));
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        List<String> a = Arrays.asList("A", "B", "B", "A", "D", "E", "A", "D");
        List<String> b = Arrays.asList("B", "A", "A", "D", "E", "A", "D");
        Comparator<String> cs = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        Diff.diffList(a, b, cs);
    }

    private static class Item<T> {
        private int m_index;
        private final Type m_type;
        private final T m_item;

        public Item(Type type, T item) {
            this.m_type = type;
            this.m_item = item;
        }

        public int getIndex() {
            return this.m_index;
        }

        public void setIndex(int index) {
            this.m_index = index;
        }

        public Type getType() {
            return this.m_type;
        }

        public T getItem() {
            return this.m_item;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            switch (this.getType()) {
                case ADD: {
                    sb.append("+");
                    break;
                }
                case DELETE: {
                    sb.append("-");
                    break;
                }
                case SAME: {
                    sb.append(" ");
                }
            }
            sb.append(" ").append(this.getItem()).append(" @").append(this.m_index);
            return sb.toString();
        }
    }

    public static enum Type {
        ADD,
        DELETE,
        SAME;

    }
}

