/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.util.IExceptionClassifier;

public final class ExceptionClassifier
implements IExceptionClassifier {
    @Nullable
    private static ExceptionClassifier m_instance;
    @Nonnull
    private final Map<String, Severity> m_knownExceptions = new HashMap<String, Severity>();
    @Nonnull
    private final List<IExceptionClassifier> m_customExceptions = new ArrayList<IExceptionClassifier>();

    @Nonnull
    public static ExceptionClassifier getInstance() {
        ExceptionClassifier instance = m_instance;
        if (instance == null) {
            instance = m_instance = new ExceptionClassifier();
        }
        return m_instance;
    }

    public void registerKnownException(@Nonnull String message, @Nonnull Severity severity) throws Exception {
        this.m_knownExceptions.put(message, severity);
    }

    public void registerClassifier(@Nonnull IExceptionClassifier exceptionClassifier) {
        this.m_customExceptions.add(exceptionClassifier);
    }

    @Override
    @Nonnull
    public Severity getExceptionSeverity(@Nonnull Throwable e) {
        ArrayList<Throwable> thrownExceptions = new ArrayList<Throwable>();
        this.addExceptionsToList(e, thrownExceptions);
        for (Throwable t : thrownExceptions) {
            Severity severity;
            String message = t.getMessage();
            if (message != null && (severity = this.getSeverityByMessage(message)) != Severity.UNKNOWN) {
                return severity;
            }
            severity = this.getSeverityForCustomExceptions(t);
            if (severity == Severity.UNKNOWN) continue;
            return severity;
        }
        return Severity.UNKNOWN;
    }

    private void addExceptionsToList(@Nonnull Throwable e, @Nonnull List<Throwable> thrownExceptions) {
        Throwable cause;
        SQLException sqle;
        thrownExceptions.add(e);
        if (e instanceof SQLException && (sqle = ((SQLException)e).getNextException()) != null) {
            this.addExceptionsToList(sqle, thrownExceptions);
        }
        if ((cause = e.getCause()) != null && cause != e) {
            this.addExceptionsToList(cause, thrownExceptions);
        }
    }

    @Nonnull
    private Severity getSeverityByMessage(@Nonnull String message) {
        for (Map.Entry<String, Severity> entry : this.m_knownExceptions.entrySet()) {
            if (!message.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return Severity.UNKNOWN;
    }

    @Nonnull
    private Severity getSeverityForCustomExceptions(@Nonnull Throwable t) {
        for (IExceptionClassifier exceptionClassifier : this.m_customExceptions) {
            Severity severity = exceptionClassifier.getExceptionSeverity(t);
            if (severity == Severity.UNKNOWN) continue;
            return severity;
        }
        return Severity.UNKNOWN;
    }

    public boolean isSevereException(@Nonnull Throwable throwable) {
        return this.getExceptionSeverity(throwable) != Severity.UNSEVERE;
    }

    public static enum Severity {
        SEVERE,
        UNSEVERE,
        UNKNOWN;

    }
}

