/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import to.etc.util.FileTool;

public class FileBackedBuffer
extends OutputStream {
    private static final byte[] NODATA = new byte[0];
    private int m_maxInMemory;
    private int m_initialAllocation;
    private boolean m_inFile;
    private File m_file;
    private byte[] m_data = NODATA;
    private int m_size;
    private boolean m_wclosed;
    private OutputStream m_fos;
    InputStream m_is;

    public FileBackedBuffer() {
        this(8192);
    }

    public FileBackedBuffer(int size) {
        this(size, size <= 8192 ? size : 8192);
    }

    public FileBackedBuffer(int size, int initial) {
        assert (size >= 0 && initial > 0);
        this.m_maxInMemory = size;
        this.m_initialAllocation = initial;
    }

    public void discard() {
        if (this.m_fos != null) {
            try {
                this.m_fos.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_fos = null;
        }
        if (this.m_is != null) {
            try {
                this.m_is.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (this.m_file != null) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_file = null;
        }
    }

    protected void finalize() throws Throwable {
        this.discard();
        super.finalize();
    }

    @Override
    public void close() throws IOException {
        if (this.m_wclosed) {
            return;
        }
        super.close();
        if (this.m_fos != null) {
            this.m_fos.close();
            this.m_fos = null;
        }
        this.m_wclosed = true;
    }

    private void reallocate(int newsz) {
        if (newsz < this.m_initialAllocation) {
            newsz = this.m_initialAllocation;
        } else if ((newsz *= 2) > this.m_maxInMemory / 2) {
            newsz = this.m_maxInMemory;
        }
        byte[] old = this.m_data;
        this.m_data = new byte[newsz];
        System.arraycopy(old, 0, this.m_data, 0, this.m_size);
    }

    private void startFileWriter() throws IOException {
        if (this.m_file == null) {
            this.m_file = File.createTempFile("filebuffer", "tmp");
        }
        this.m_inFile = true;
        this.m_fos = new FileOutputStream(this.m_file);
        this.m_fos.write(this.m_data, 0, this.m_size);
        this.m_data = NODATA;
    }

    public File asFile() throws IOException {
        if (this.m_file == null) {
            this.startFileWriter();
        }
        return this.m_file;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.m_fos != null) {
            this.m_fos.write(b, off, len);
            this.m_size += len;
            return;
        }
        if (this.m_wclosed) {
            throw new IOException("The buffer has been closed.");
        }
        int newsize = this.m_size + len;
        if (newsize >= this.m_maxInMemory) {
            this.startFileWriter();
            this.m_fos.write(b, off, len);
            this.m_size += len;
            return;
        }
        if (newsize >= this.m_data.length) {
            this.reallocate(newsize);
        }
        System.arraycopy(b, off, this.m_data, this.m_size, len);
        this.m_size += len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.m_fos != null) {
            this.m_fos.write(b);
            ++this.m_size;
            return;
        }
        if (this.m_wclosed) {
            throw new IOException("The buffer has been closed.");
        }
        int newsize = this.m_size + 1;
        if (newsize >= this.m_maxInMemory) {
            this.startFileWriter();
            this.m_fos.write(b);
            ++this.m_size;
            return;
        }
        if (newsize >= this.m_data.length) {
            this.reallocate(newsize);
        }
        this.m_data[this.m_size] = (byte)b;
        ++this.m_size;
    }

    public void clear() {
        if (this.m_fos != null) {
            try {
                this.m_fos.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.m_fos = null;
        }
        if (this.m_is != null) {
            try {
                this.m_is.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        this.m_inFile = false;
        this.m_wclosed = false;
        this.m_size = 0;
    }

    private void checkReadable() throws IOException {
        if (!this.m_wclosed) {
            throw new IllegalStateException("The writer has not yet been closed.");
        }
        if (this.m_is != null) {
            throw new IllegalStateException("The previous input stream has not yet been closed");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkReadable();
        this.m_is = this.m_inFile ? new FileInputStream(this.m_file){

            @Override
            public void close() throws IOException {
                FileBackedBuffer.this.m_is = null;
                super.close();
            }
        } : new ByteArrayInputStream(this.m_data, 0, this.m_size){

            @Override
            public void close() throws IOException {
                FileBackedBuffer.this.m_is = null;
                super.close();
            }
        };
        return this.m_is;
    }

    public int size() {
        return this.m_size;
    }

    public void copy(OutputStream os) throws IOException {
        this.checkReadable();
        if (!this.m_inFile) {
            os.write(this.m_data, 0, this.m_size);
        } else {
            try (InputStream is = this.getInputStream();){
                FileTool.copyFile(os, is);
            }
        }
    }
}

