/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import to.etc.util.FileTool;

public class FileContentInfo {
    private File m_source;
    private String m_name;
    private String m_encoding;
    private boolean m_text;
    private String m_extension;
    private int m_tabSize = 4;
    private int m_maxLineSize = 0;
    private int m_numNulls = 0;
    private int m_numUtf8 = 0;
    private int m_numNonISO = 0;
    private int m_numHigh = 0;
    private int m_numLines = 0;
    private boolean m_encodingValid;

    private FileContentInfo(File src, String name) {
        this.m_source = src;
        this.m_name = name;
    }

    @Nonnull
    public static FileContentInfo createType(@Nonnull File src, @Nonnull String name) throws Exception {
        FileContentInfo fc = new FileContentInfo(src, name);
        fc.load();
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws Exception {
        FileInputStream is = new FileInputStream(this.m_source);
        int utfleadin = 0;
        byte[] buf = new byte[8192];
        try {
            int sz;
            int uix = 0;
            int curll = 0;
            while (0 < (sz = ((InputStream)is).read(buf))) {
                for (int i = 0; i < sz; ++i) {
                    byte v = buf[i];
                    if (v == 0) {
                        ++this.m_numNulls;
                    }
                    if (uix > 0) {
                        if ((v & 0xC0) != 128) {
                            uix = 0;
                            if (utfleadin >= 128 && utfleadin <= 160) {
                                ++this.m_numNonISO;
                            } else {
                                ++this.m_numHigh;
                            }
                            if (v >= 128 && v <= 160) {
                                ++this.m_numNonISO;
                            } else {
                                ++this.m_numHigh;
                            }
                            curll += 2;
                            continue;
                        }
                        if (--uix != 0) continue;
                        ++this.m_numUtf8;
                        ++curll;
                        continue;
                    }
                    if (v == 10) {
                        if (curll > this.m_maxLineSize) {
                            this.m_maxLineSize = curll;
                        }
                        curll = 0;
                        ++this.m_numLines;
                        continue;
                    }
                    if ((v & 0xC0) >= 192) {
                        if ((v & 0xF8) == 240) {
                            uix = 3;
                            continue;
                        }
                        if ((v & 0xF0) == 224) {
                            uix = 2;
                            continue;
                        }
                        if ((v & 0xE0) == 192) {
                            uix = 1;
                            continue;
                        }
                        if (v >= 128 && v <= 160) {
                            ++this.m_numNonISO;
                            continue;
                        }
                        ++this.m_numHigh;
                        continue;
                    }
                    if (v <= 128) continue;
                    if (v >= 128 && v <= 160) {
                        ++this.m_numNonISO;
                        continue;
                    }
                    ++this.m_numHigh;
                }
            }
            this.m_extension = FileTool.getFileExtension(this.m_source.getName());
            this.m_text = true;
            this.m_encodingValid = true;
            if (this.m_numNulls > 0) {
                this.m_text = false;
                this.m_encodingValid = false;
            }
            if (this.m_numUtf8 > 0 || this.m_numNonISO == 0 && this.m_numHigh == 0) {
                this.m_encoding = "utf-8";
            } else if (this.m_numNonISO > 0) {
                this.m_encoding = "win1252";
                if (this.m_numUtf8 > 0) {
                    this.m_encodingValid = false;
                }
            } else {
                this.m_encoding = "iso-8859-15";
                if (this.m_numUtf8 > 0) {
                    this.m_encodingValid = false;
                }
            }
        }
        catch (Throwable throwable) {
            FileTool.closeAll(is);
            throw throwable;
        }
        FileTool.closeAll(is);
    }

    public File getSource() {
        return this.m_source;
    }

    public String getName() {
        return this.m_name;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isText() {
        return this.m_text;
    }

    public String getExtension() {
        return this.m_extension;
    }

    public int getTabSize() {
        return this.m_tabSize;
    }

    public int getMaxLineSize() {
        return this.m_maxLineSize;
    }

    public int getNumNulls() {
        return this.m_numNulls;
    }

    public int getNumUtf8() {
        return this.m_numUtf8;
    }

    public int getNumNonISO() {
        return this.m_numNonISO;
    }

    public int getNumHigh() {
        return this.m_numHigh;
    }

    public int getNumLines() {
        return this.m_numLines;
    }

    public boolean isEncodingValid() {
        return this.m_encodingValid;
    }
}

