/*
 * Decompiled with CFR 0.152.
 */
package to.etc.util;

public class GIS {
    private static final double RDX0 = 155000.0;
    private static final double RDY0 = 463000.0;
    private static final double WGS84LA0 = 52.1551744;
    private static final double WGS84LO0 = 5.38720621;
    private static final double IGN = Double.MAX_VALUE;
    private static final double[][] K_FACTORS = new double[][]{{Double.MAX_VALUE, 3235.65389, -0.2475, -0.0655}, {-0.00738, -1.2E-4}, {-32.58297, -0.84978, -0.01709, -3.9E-4}, {Double.MAX_VALUE}, {0.0053, 3.3E-4}};
    private static final double[][] L_FACTORS = new double[][]{{Double.MAX_VALUE, 0.01199, 2.2E-4}, {5260.52916, 105.94684, 2.45656, 0.05594, 0.00128}, {-2.2E-4}, {-0.81885, -0.05607, -0.00256}, {Double.MAX_VALUE}, {2.6E-4}};
    private double m_long;
    private double m_lat;

    public static void convertRDToWGS84(double[] result, double rdx, double rdy) {
        double dX = (rdx - 155000.0) / 100000.0;
        double dY = (rdy - 463000.0) / 100000.0;
        double wgslat = 0.0;
        for (int x = 0; x < K_FACTORS.length; ++x) {
            for (int y = 0; y < K_FACTORS[x].length; ++y) {
                if (K_FACTORS[x][y] == Double.MAX_VALUE) continue;
                wgslat += K_FACTORS[x][y] * Math.pow(dX, x) * Math.pow(dY, y);
            }
        }
        result[0] = 52.1551744 + wgslat / 3600.0;
        double wgslon = 0.0;
        for (int x = 0; x < L_FACTORS.length; ++x) {
            for (int y = 0; y < L_FACTORS[x].length; ++y) {
                if (L_FACTORS[x][y] == Double.MAX_VALUE) continue;
                wgslon += L_FACTORS[x][y] * Math.pow(dX, x) * Math.pow(dY, y);
            }
        }
        result[1] = 5.38720621 + wgslon / 3600.0;
    }

    public void convertRD(double rdx, double rdy) {
        double dX = (rdx - 155000.0) / 100000.0;
        double dY = (rdy - 463000.0) / 100000.0;
        double wgslat = 0.0;
        for (int x = 0; x < K_FACTORS.length; ++x) {
            for (int y = 0; y < K_FACTORS[x].length; ++y) {
                if (K_FACTORS[x][y] == Double.MAX_VALUE) continue;
                wgslat += K_FACTORS[x][y] * Math.pow(dX, x) * Math.pow(dY, y);
            }
        }
        this.m_lat = 52.1551744 + wgslat / 3600.0;
        double wgslon = 0.0;
        for (int x = 0; x < L_FACTORS.length; ++x) {
            for (int y = 0; y < L_FACTORS[x].length; ++y) {
                if (L_FACTORS[x][y] == Double.MAX_VALUE) continue;
                wgslon += L_FACTORS[x][y] * Math.pow(dX, x) * Math.pow(dY, y);
            }
        }
        this.m_long = 5.38720621 + wgslon / 3600.0;
    }

    public double getLatitude() {
        return this.m_lat;
    }

    public double getLongitude() {
        return this.m_long;
    }

    public static double deg2rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double distanceInDeg(double alat, double alng, double blat, double blng) {
        double ala = GIS.deg2rad(alat);
        double bla = GIS.deg2rad(blat);
        double alo = GIS.deg2rad(alng);
        double blo = GIS.deg2rad(blng);
        double r = 6367000.0;
        double dlat = ala - bla;
        double dlong = alo - blo;
        double tla = Math.sin(dlat / 2.0);
        double tlo = Math.sin(dlong / 2.0);
        double ta = tla * tla + Math.cos(ala) * Math.cos(bla) * tlo * tlo;
        double tc = 2.0 * Math.atan2(Math.sqrt(ta), Math.sqrt(1.0 - ta));
        return r * tc;
    }

    public static void main(String[] args) {
        try {
            double[] res = new double[2];
            GIS.convertRDToWGS84(res, 120700.723, 487525.501);
            System.out.println("Westertoren (" + res[0] + ", " + res[1] + ")");
            GIS.convertRDToWGS84(res, 233883.131, 582065.167);
            System.out.println("Martinitoren (" + res[0] + ", " + res[1] + ")");
            GIS g = new GIS();
            g.convertRD(162558.0, 498715.0);
            System.out.println("Pascallaan (" + g.getLatitude() + ", " + g.getLongitude() + ")");
            g.convertRD(144690.0, 487111.0);
            System.out.println("Peggy Ashcroftstr 11 (" + g.getLatitude() + ", " + g.getLongitude() + ")");
            g.convertRD(163705.0, 503159.0);
            System.out.println("Oostrandpark 81 (" + g.getLatitude() + ", " + g.getLongitude() + ")");
            double d = GIS.distanceInDeg(52.518971777678, 6.095555421998, 51.9163557064, 4.4868857542);
            System.out.println("D=" + d);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

